/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.CompositeFontResource;
import java.util.HashMap;

class CompositeGlyphMapper
extends CharToGlyphMapper {
    public static final int SLOTMASK = -16777216;
    public static final int GLYPHMASK = 0xFFFFFF;
    public static final int NBLOCKS = 216;
    public static final int BLOCKSZ = 256;
    public static final int MAXUNICODE = 55296;
    private static final int SIMPLE_ASCII_MASK_START = 32;
    private static final int SIMPLE_ASCII_MASK_END = 126;
    private static final int ASCII_COUNT = 95;
    private boolean asciiCacheOK;
    private char[] charToGlyph;
    CompositeFontResource font;
    CharToGlyphMapper[] slotMappers;
    HashMap<Integer, Integer> glyphMap;

    public CompositeGlyphMapper(CompositeFontResource compositeFontResource) {
        this.font = compositeFontResource;
        this.missingGlyph = 0;
        this.glyphMap = new HashMap();
        this.slotMappers = new CharToGlyphMapper[compositeFontResource.getNumSlots()];
        this.asciiCacheOK = true;
    }

    @Override
    public int getNumGlyphs() {
        return this.getSlotMapper(0).getNumGlyphs();
    }

    private final CharToGlyphMapper getSlotMapper(int n) {
        CharToGlyphMapper charToGlyphMapper = this.slotMappers[n];
        if (charToGlyphMapper == null) {
            this.slotMappers[n] = charToGlyphMapper = this.font.getSlotResource(n).getGlyphMapper();
        }
        return charToGlyphMapper;
    }

    @Override
    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public final int compositeGlyphCode(int n, int n2) {
        return n << 24 | n2 & 0xFFFFFF;
    }

    private final int convertToGlyph(int n) {
        for (int i = 0; i < this.font.getNumSlots(); ++i) {
            CharToGlyphMapper charToGlyphMapper = this.getSlotMapper(i);
            int n2 = charToGlyphMapper.charToGlyph(n);
            if (n2 == charToGlyphMapper.getMissingGlyphCode()) continue;
            n2 = this.compositeGlyphCode(i, n2);
            this.glyphMap.put(n, n2);
            return n2;
        }
        this.glyphMap.put(n, this.missingGlyph);
        return this.missingGlyph;
    }

    private int getAsciiGlyphCode(int n) {
        if (!this.asciiCacheOK || n > 126 || n < 32) {
            return -1;
        }
        if (this.charToGlyph == null) {
            char[] cArray = new char[95];
            CharToGlyphMapper charToGlyphMapper = this.getSlotMapper(0);
            int n2 = charToGlyphMapper.getMissingGlyphCode();
            for (int i = 0; i < 95; ++i) {
                int n3 = charToGlyphMapper.charToGlyph(32 + i);
                if (n3 == n2) {
                    this.charToGlyph = null;
                    this.asciiCacheOK = false;
                    return -1;
                }
                cArray[i] = (char)n3;
            }
            this.charToGlyph = cArray;
        }
        int n4 = n - 32;
        return this.charToGlyph[n4];
    }

    @Override
    public int getGlyphCode(int n) {
        int n2 = this.getAsciiGlyphCode(n);
        if (n2 >= 0) {
            return n2;
        }
        Integer n3 = this.glyphMap.get(n);
        if (n3 != null) {
            return n3;
        }
        return this.convertToGlyph(n);
    }
}

