/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Logger;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class CommandResultHolder {
    private static final Logger log = Logger.getLogger(CommandResultHolder.class.getName());
    private static final String poisonResult = "CommandResultHolder.POISON";
    protected static final String CMD_TIMED_OUT_MSG = "ERROR: Command timed out";
    protected static final String CMD_NULL_RESULT_MSG = "ERROR: Got a null result";
    private final String queueId;
    private final SingleEntryAsyncQueue<String> holder;

    public CommandResultHolder(String queueId, long timeoutInSeconds) {
        this.holder = new SingleEntryAsyncQueue(timeoutInSeconds);
        this.holder.setPoison(poisonResult);
        this.queueId = queueId;
    }

    public String getResult() {
        log.fine(String.valueOf(this.hdr()) + "called");
        String result = this.holder.pollToGetContentUntilTimeout();
        if (result == null) {
            result = CMD_TIMED_OUT_MSG;
        } else if (this.holder.isPoison(result)) {
            result = CMD_NULL_RESULT_MSG;
        }
        StringBuilder msg = new StringBuilder(String.valueOf(this.hdr()) + "-> " + result);
        if (CMD_TIMED_OUT_MSG.equals(result)) {
            msg.append(" after ").append(this.holder.getTimeoutInSeconds()).append(" seconds.");
        }
        log.fine(msg.toString());
        return result;
    }

    public boolean putResult(String res) {
        return this.holder.putContent(res);
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public String peek() {
        return this.holder.peek();
    }

    public void poisonPollers() {
        this.holder.poisonPollers();
    }

    private String hdr() {
        return "\t" + CommandQueue.getIdentification("commandResultHolder", this.queueId) + " getResult() ";
    }
}

