/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.service.DriverService;

public class DriverCommandExecutor
extends HttpCommandExecutor {
    private final DriverService service;

    public DriverCommandExecutor(DriverService service) {
        super(service.getUrl());
        this.service = service;
    }

    protected DriverCommandExecutor(DriverService service, Map<String, CommandInfo> additionalCommands) {
        super(additionalCommands, service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            this.service.start();
        }
        try {
            Response response = super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The driver server has unexpectedly died!", t);
            }
            Throwables.propagateIfPossible((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.service.stop();
            }
        }
    }
}

