/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Components;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.shop.claims.ExposureTopComponent;
import org.shop.editor.CustomerEditorTopComponent;
import org.shop.tools.EntityService;

public class Report4
extends JFrame
implements TableModelListener {
    private static String[][] dataField;
    Integer client;
    Integer version;
    String PU;
    Boolean boo = true;
    String[] columnNames = new String[]{"ITEM", "CATEGORY", "N/A", "EXCELLENT", "<html>ABOVE<br> AVERAGE</html>", "AVERAGE", "<html>BELOW<br> AVERAGE</html>", "POOR", "RATING"};
    String[][] data;
    Integer[][] datac;
    Boolean[][] datab;
    Boolean disposed = false;
    Boolean bSaveAble = false;
    CustomerEditorTopComponent my = (CustomerEditorTopComponent)this.getTC("CustomerEditorTopComponent");
    ExposureTopComponent my3 = (ExposureTopComponent)this.getTC("ExposureTopComponent");
    Timer timer;
    int ht = 16;
    Timer timerRefresh = null;
    Integer cntMax;
    Integer cnt;
    Integer period;
    Boolean booColor = true;
    Boolean secondTimeColor = false;
    JButton bClear;
    JButton bClose;
    JButton bPrint;
    JButton bSave;
    private JLabel deviation;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPanel jp;
    private JLabel max;
    private JLabel percentage;
    private JLabel risk;
    private JLabel score;
    private JTable table;

    TopComponent getTC(String name) {
        TopComponent viewTC = WindowManager.getDefault().findTopComponent(name);
        if (viewTC != null) {
            viewTC.open();
        }
        return viewTC;
    }

    public Report4(String pu, Integer clnt, Integer vrsn) {
        this.initComponents();
        this.setTitle("Scoring Worksheet");
        this.PU = pu;
        this.client = clnt;
        this.setVersion(vrsn);
        this.bClose.addActionListener(new ExposureListener());
        this.bPrint.addActionListener(new ExposureListener());
        this.bClear.addActionListener(new ExposureListener());
        this.bSave.addActionListener(new ExposureListener());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Report4.this.bSaveAble = Report4.this.my.tfPolicy.getText().length() > 0;
                Report4.this.sumIt();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                boolean a = true;
            }

            @Override
            public void windowStateChanged(WindowEvent e) {
                boolean a = true;
                if (e.getNewState() == 205) {
                    // empty if block
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Report4.this.disposed = true;
                Report4.this.dispose();
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.boo.booleanValue()) {
            return;
        }
        this.boo = false;
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        int posEnd = model.getColumnCount() - 1;
        String columnName = model.getColumnName(column);
        if (column == posEnd) {
            // empty if block
        }
        this.sumIt();
        this.boo = true;
    }

    void sumIt() {
        TableModel model = this.table.getModel();
        int posEnd = model.getColumnCount() - 1;
        Float tot = Float.valueOf(0.0f);
        Float totmax = Float.valueOf(0.0f);
        Float per = Float.valueOf(0.0f);
        for (int i = 0; i < model.getRowCount(); ++i) {
            String tf2 = (String)model.getValueAt(i, posEnd);
            totmax = Float.valueOf(totmax.floatValue() + (this.datab[i][2] != false ? 0.0f : this.datac[i][10].floatValue()));
            try {
                if (tf2 == null || tf2.length() <= 0) continue;
                Float tf1 = Float.valueOf(Float.parseFloat(tf2));
                tot = Float.valueOf(tot.floatValue() + tf1.floatValue());
                continue;
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
        }
        this.score.setText(tot.toString());
        this.max.setText(totmax.toString());
        if (totmax.floatValue() > 0.0f) {
            per = Float.valueOf(tot.floatValue() / totmax.floatValue());
        }
        NumberFormat formatnum = NumberFormat.getPercentInstance();
        formatnum.setMaximumFractionDigits(1);
        formatnum.setMinimumFractionDigits(1);
        this.percentage.setText(formatnum.format(per));
        Scoregroup grp = this.ScoreAdj(tot.intValue());
        this.risk.setText(grp.quality);
        this.deviation.setText(formatnum.format(grp.dev));
        Boolean boo = !grp.quality.equals("Not Rateable");
        this.jLabel26.setVisible(boo);
        this.deviation.setVisible(boo);
        this.bSave.setEnabled(boo != false && this.bSaveAble != false);
        if (boo.booleanValue() && this.bSaveAble.booleanValue()) {
            this.saveEnabled();
        }
        this.bPrint.requestFocus();
    }

    Scoregroup ScoreAdj(Integer count) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList6 = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)5).setParameter("vehicle", (Object)2).setParameter("series", (Object)3).setParameter("name", (Object)"Scoregroup").getResultList();
        Scoregroup grp = new Scoregroup();
        for (Components entity6 : resultList6) {
            if (count < entity6.getAdditive()) continue;
            grp.dev = entity6.getFactor();
            grp.quality = entity6.getDisplay();
        }
        return grp;
    }

    void minimize() {
        this.setState(1);
    }

    public void setVersion(Integer vrsn) {
        if (this.version != vrsn || vrsn == null) {
            this.version = vrsn;
            this.version = this.version == null ? this.latestVersion() : this.version;
            this.loadData();
            this.clear();
        }
    }

    Integer latestVersion() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.name").setParameter("client", (Object)this.client).setParameter("name", (Object)"Search").getResultList();
        Integer in = 0;
        for (Components c : resultList) {
            in = c.getVersion() > in ? c.getVersion() : in;
        }
        return in;
    }

    private void printDebugData(JTable table) {
        int numRows = table.getRowCount();
        int numCols = table.getColumnCount();
        TableModel model = table.getModel();
        System.out.println("Value of data: ");
        for (int i = 0; i < numRows; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < numCols; ++j) {
                System.out.print("  " + model.getValueAt(i, j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }

    void loadData() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)5).setParameter("vehicle", (Object)2).setParameter("series", (Object)3).setParameter("name", (Object)"Scorelabel").getResultList();
        List resultList1 = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)5).setParameter("vehicle", (Object)2).setParameter("series", (Object)3).setParameter("name", (Object)"Scorevalue").getResultList();
        this.data = new String[resultList.size()][9];
        this.datac = new Integer[resultList.size()][11];
        this.datab = new Boolean[resultList1.size()][9];
        int j = 0;
        for (Components comp : resultList) {
            String[] str = comp.getDisplay().split(":", -99);
            for (int i = 0; i < str.length; ++i) {
                this.data[j][i] = str[i];
            }
            this.data[j][8] = "";
            ++j;
        }
        j = 0;
        int minval = 99999;
        int maxval = 0;
        for (Components comp : resultList1) {
            String[] str = comp.getDisplay().split(":", -99);
            for (int i = 0; i < str.length; ++i) {
                this.datac[j][i] = Integer.parseInt(str[i]);
                minval = Math.min(this.datac[j][i], minval);
                maxval = Math.max(this.datac[j][i], maxval);
            }
            this.datac[j][9] = minval;
            this.datac[j][10] = maxval;
            ++j;
        }
    }

    void clear() {
        int i;
        DefaultTableModel tab1 = new DefaultTableModel(this.data, this.columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (int i2 = 0; i2 < this.datab.length; ++i2) {
            for (int j = 0; j < this.datab[0].length; ++j) {
                this.datab[i2][j] = false;
            }
        }
        this.table.removeAll();
        this.table.setModel(tab1);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 250));
        this.table.setFillsViewportHeight(true);
        this.table.getModel().addTableModelListener(this);
        int posEnd = this.table.getColumnCount() - 1;
        this.sumIt();
        TableColumnModel mc = this.table.getColumnModel();
        for (i = 1; i < this.table.getColumnModel().getColumnCount() - 1; ++i) {
            mc.getColumn(i).setCellRenderer(new numRenderer1());
        }
        mc.getColumn(0).setCellRenderer(new numRenderer2());
        mc.getColumn(posEnd).setCellRenderer(new numRenderer2());
        mc.getColumn(0).setPreferredWidth(35);
        mc.getColumn(1).setPreferredWidth(200);
        mc.getColumn(2).setPreferredWidth(35);
        mc.getColumn(8).setPreferredWidth(50);
        for (i = 0; i <= posEnd; ++i) {
            if (i > 0 && i < posEnd) {
                this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(this.table, 2));
                continue;
            }
            this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(this.table, 0));
        }
    }

    void saveEnabled() {
        this.bSave.setEnabled(true);
        this.flash(this.bSave, true, 5000, 400);
    }

    void flash(JButton cb, Boolean boo, Integer len, Integer prd) {
        if (!boo.booleanValue() || this.secondTimeColor.booleanValue()) {
            return;
        }
        this.secondTimeColor = true;
        this.cntMax = len;
        this.cnt = 0;
        this.period = prd;
        this.booColor = true;
        if (this.timerRefresh != null) {
            this.timerRefresh.setRepeats(false);
            this.timerRefresh.stop();
        }
        this.timerRefresh = new Timer(this.period, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Report4.this.cnt = Report4.this.cnt + Report4.this.period;
                if (Report4.this.cntMax < Report4.this.cnt) {
                    Report4.this.timerRefresh.setRepeats(false);
                    Report4.this.timerRefresh.stop();
                    Report4.this.bSave.setForeground(Color.black);
                } else if (Report4.this.booColor.booleanValue()) {
                    Report4.this.booColor = false;
                    Report4.this.bSave.setForeground(Color.red);
                } else {
                    Report4.this.booColor = true;
                    Report4.this.bSave.setForeground(Color.black);
                }
            }
        });
        this.timerRefresh.setInitialDelay(0);
        this.timerRefresh.setRepeats(true);
        this.timerRefresh.start();
    }

    private void initComponents() {
        this.jp = new JPanel();
        this.jLabel15 = new JLabel();
        this.jPanel1 = new JPanel();
        this.bPrint = new JButton();
        this.bClose = new JButton();
        this.bClear = new JButton();
        this.bSave = new JButton();
        this.jLabel9 = new JLabel();
        this.jLabel16 = new JLabel();
        this.score = new JLabel();
        this.jLabel17 = new JLabel();
        this.max = new JLabel();
        this.percentage = new JLabel();
        this.jLabel18 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jLabel25 = new JLabel();
        this.risk = new JLabel();
        this.deviation = new JLabel();
        this.jLabel26 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel21 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel27 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel15.setFont(new Font("Tahoma", 1, 14));
        this.jLabel15.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel15.text_1"));
        this.jLabel15.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel15.toolTipText_1"));
        this.bPrint.setText(NbBundle.getMessage(Report4.class, (String)"Report4.bPrint.text_1"));
        this.bPrint.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.bPrint.toolTipText_1"));
        this.bPrint.setActionCommand(NbBundle.getMessage(Report4.class, (String)"Report4.bPrint.actionCommand_1"));
        this.bPrint.setName("bPrint");
        this.bClose.setText(NbBundle.getMessage(Report4.class, (String)"Report4.bClose.text_1"));
        this.bClose.setActionCommand(NbBundle.getMessage(Report4.class, (String)"Report4.bClose.actionCommand_1"));
        this.bClose.setName("bReset");
        this.bClear.setText(NbBundle.getMessage(Report4.class, (String)"Report4.bClear.text_1"));
        this.bClear.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.bClear.toolTipText_1"));
        this.bClear.setActionCommand(NbBundle.getMessage(Report4.class, (String)"Report4.bClear.actionCommand_1"));
        this.bClear.setName("bClear");
        this.bSave.setText(NbBundle.getMessage(Report4.class, (String)"Report4.bSave.text"));
        this.bSave.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.bSave.toolTipText"));
        this.bSave.setActionCommand(NbBundle.getMessage(Report4.class, (String)"Report4.bSave.actionCommand"));
        this.bSave.setName("bPrint");
        this.jLabel9.setFont(new Font("Tahoma", 0, 18));
        this.jLabel9.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel9.text_1"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSave, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPrint, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bClose, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bClear, -2, 72, -2).addGap(5, 5, 5)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bClose).addComponent(this.bPrint).addComponent(this.bClear).addComponent(this.bSave).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel16.setFont(new Font("Tahoma", 1, 14));
        this.jLabel16.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel16.text_1"));
        this.jLabel16.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel16.toolTipText_1"));
        this.score.setFont(new Font("Tahoma", 1, 14));
        this.score.setHorizontalAlignment(4);
        this.score.setText(NbBundle.getMessage(Report4.class, (String)"Report4.score.text_1"));
        this.score.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.score.toolTipText_1"));
        this.jLabel17.setFont(new Font("Tahoma", 1, 14));
        this.jLabel17.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel17.text_1"));
        this.jLabel17.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel17.toolTipText_1"));
        this.max.setFont(new Font("Tahoma", 1, 14));
        this.max.setHorizontalAlignment(4);
        this.max.setText(NbBundle.getMessage(Report4.class, (String)"Report4.max.text_1"));
        this.max.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.max.toolTipText_1"));
        this.percentage.setFont(new Font("Tahoma", 1, 14));
        this.percentage.setHorizontalAlignment(4);
        this.percentage.setText(NbBundle.getMessage(Report4.class, (String)"Report4.percentage.text_1"));
        this.percentage.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.percentage.toolTipText_1"));
        this.jLabel18.setFont(new Font("Tahoma", 1, 14));
        this.jLabel18.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel18.text_1"));
        this.jLabel18.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel18.toolTipText_1"));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jScrollPane1.setViewportView(this.table);
        this.jLabel25.setFont(new Font("Tahoma", 1, 14));
        this.jLabel25.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel25.text"));
        this.jLabel25.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel25.toolTipText"));
        this.risk.setFont(new Font("Tahoma", 1, 14));
        this.risk.setHorizontalAlignment(4);
        this.risk.setText(NbBundle.getMessage(Report4.class, (String)"Report4.risk.text"));
        this.risk.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.risk.toolTipText"));
        this.deviation.setFont(new Font("Tahoma", 1, 14));
        this.deviation.setHorizontalAlignment(4);
        this.deviation.setText(NbBundle.getMessage(Report4.class, (String)"Report4.deviation.text"));
        this.deviation.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.deviation.toolTipText"));
        this.jLabel26.setFont(new Font("Tahoma", 1, 14));
        this.jLabel26.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel26.text"));
        this.jLabel26.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel26.toolTipText"));
        GroupLayout jpLayout = new GroupLayout(this.jp);
        this.jp.setLayout(jpLayout);
        jpLayout.setHorizontalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addContainerGap().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addComponent(this.jSeparator1).addGap(712, 712, 712)).addGroup(jpLayout.createSequentialGroup().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, jpLayout.createSequentialGroup().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel15, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jpLayout.createSequentialGroup().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel26, -2, 189, -2).addComponent(this.jLabel25).addComponent(this.jLabel17).addComponent(this.jLabel18).addComponent(this.jLabel16, -2, 229, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.score, GroupLayout.Alignment.TRAILING).addComponent(this.max, GroupLayout.Alignment.TRAILING).addComponent(this.percentage, GroupLayout.Alignment.TRAILING).addComponent(this.risk, GroupLayout.Alignment.TRAILING, -2, 148, -2).addComponent(this.deviation, GroupLayout.Alignment.TRAILING, -2, 148, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 116, Short.MAX_VALUE))).addGap(586, 586, 586))).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))));
        jpLayout.linkSize(0, this.deviation, this.max, this.percentage, this.risk, this.score);
        jpLayout.linkSize(0, this.jLabel16, this.jLabel17, this.jLabel18, this.jLabel25, this.jLabel26);
        jpLayout.setVerticalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addGap(12, 12, 12).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.score, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE)).addGap(1, 1, 1).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.max)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.percentage)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.risk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26).addComponent(this.deviation)).addGap(34, 34, 34).addComponent(this.jScrollPane1, -2, 290, -2)));
        this.jLabel21.setFont(new Font("Tahoma", 1, 14));
        this.jLabel21.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel21.text"));
        this.jLabel21.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel21.toolTipText"));
        this.jLabel24.setFont(new Font("Tahoma", 1, 14));
        this.jLabel24.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel24.text"));
        this.jLabel24.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel24.toolTipText"));
        this.jLabel23.setFont(new Font("Tahoma", 1, 14));
        this.jLabel23.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel23.text"));
        this.jLabel23.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel23.toolTipText"));
        this.jLabel22.setFont(new Font("Tahoma", 1, 14));
        this.jLabel22.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel22.text"));
        this.jLabel22.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel22.toolTipText"));
        this.jLabel20.setFont(new Font("Tahoma", 1, 14));
        this.jLabel20.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel20.text"));
        this.jLabel20.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel20.toolTipText"));
        this.jLabel19.setFont(new Font("Tahoma", 1, 14));
        this.jLabel19.setHorizontalAlignment(2);
        this.jLabel19.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel19.text"));
        this.jLabel19.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel19.toolTipText"));
        this.jLabel27.setFont(new Font("Tahoma", 1, 14));
        this.jLabel27.setHorizontalAlignment(2);
        this.jLabel27.setText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel27.text"));
        this.jLabel27.setToolTipText(NbBundle.getMessage(Report4.class, (String)"Report4.jLabel27.toolTipText"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel20, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel22, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel23, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel24, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel27, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel24).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jp, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jp, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Report4.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Report4.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Report4.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Report4.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Report4("FleetDB", 1, 1000).setVisible(true);
            }
        });
    }

    void creatForm() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report4.this.setVisible(true);
            }
        });
    }

    void printIt() {
        final Report4 comp = this;
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat preformat = pjob.defaultPage();
        preformat.setOrientation(0);
        PageFormat postformat = pjob.pageDialog(preformat);
        if (preformat != postformat) {
            pjob.setPrintable(new Printable(){

                @Override
                public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                    if (page > 0) {
                        return 1;
                    }
                    Dimension dim = comp.getSize();
                    double cHeight = dim.getHeight();
                    double cWidth = dim.getWidth();
                    double pHeight = pf.getImageableHeight();
                    double pWidth = pf.getImageableWidth();
                    double pXStart = pf.getImageableX();
                    double pYStart = pf.getImageableY();
                    double xRatio = pWidth / cWidth;
                    double yRatio = pHeight / cHeight;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.translate(pXStart, pYStart);
                    double scale = Math.min(xRatio, yRatio);
                    g2.scale(scale, scale);
                    comp.paint(g2);
                    return 0;
                }
            });
            if (pjob.printDialog()) {
                try {
                    pjob.print();
                }
                catch (PrinterException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    class ExposureListener
    implements ActionListener {
        ExposureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Print")) {
                Report4.this.jPanel1.setVisible(false);
                Report4.this.printIt();
                Report4.this.jPanel1.setVisible(true);
            } else if (cmd.equals("Clear")) {
                Report4.this.clear();
            } else if (cmd.equals("Save")) {
                if (Report4.this.my3.Deviation.isEnabled()) {
                    NumberFormat formatnum = NumberFormat.getPercentInstance();
                    try {
                        Float flt = Float.valueOf(formatnum.parse(Report4.this.deviation.getText()).floatValue());
                        Report4.this.my3.Deviation.setText(flt.toString());
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        Report4.this.my3.Deviation.setText("No Value");
                    }
                    Report4.this.setAlwaysOnTop(true);
                    Report4.this.my3.requestActive();
                    Report4.this.my3.bSave.setEnabled(true);
                    Report4.this.my3.fireAction(Report4.this.my3.bSave, "Save");
                    Report4.this.timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Report4.this.setAlwaysOnTop(false);
                            Report4.this.minimize();
                            Report4.this.timer.stop();
                            Report4.this.timer = null;
                        }
                    });
                    Report4.this.timer.start();
                } else {
                    JOptionPane.showMessageDialog(null, "Policy is locked, Scoring Deviation cannot be transfered.", "Transfer Scoring Deviation", 0);
                }
            } else if (cmd.equals("Close")) {
                Report4.this.disposed = true;
                Report4.this.dispose();
            }
        }
    }

    private static class HeaderRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer renderer;
        int horAlignment;

        public HeaderRenderer(JTable table, int horizontalAlignment) {
            this.horAlignment = horizontalAlignment;
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            JLabel label = (JLabel)c;
            label.setHorizontalAlignment(this.horAlignment);
            Font fnt = label.getFont();
            label.setFont(new Font(fnt.getFontName(), 1, fnt.getSize()));
            label.setBackground(Color.darkGray);
            label.setForeground(Color.white);
            return label;
        }
    }

    class Scoregroup {
        String quality = "Not Rateable";
        Float dev = Float.valueOf(0.0f);

        Scoregroup() {
        }
    }

    public class numRenderer
    extends DefaultTableCellRenderer {
        Integer in;

        public numRenderer(Integer in) {
            this.in = in;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                if (this.in == 0) {
                    this.setToolTipText("Double click to enter value");
                    this.setForeground(Color.BLUE);
                }
                this.setBackground(Report4.this.table.getBackground());
                Font fnt = this.getFont();
                this.setFont(new Font(fnt.getFontName(), 1, fnt.getSize()));
                this.setHorizontalAlignment(0);
                this.setText((String)value);
            }
        }
    }

    public class numRenderer1
    extends JTextArea
    implements TableCellRenderer {
        private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();

        public numRenderer1() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setMargin(new Insets(0, 5, 0, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            int cWidth = table2.getTableHeader().getColumnModel().getColumn(column).getWidth();
            this.setSize(new Dimension(cWidth, 1000));
            int prefH = this.getPreferredSize().height;
            Report4.this.ht = column == 1 ? 16 : Report4.this.ht;
            Report4.this.ht = prefH > Report4.this.ht ? prefH : Report4.this.ht;
            this.setBackground(Report4.this.table.getBackground());
            if (column > 1 && column < 8) {
                this.setToolTipText("Click to select");
                if (hasFocus) {
                    if (!Report4.this.datab[row][column].booleanValue()) {
                        for (int j = 0; j < Report4.this.datab[0].length; ++j) {
                            Report4.this.datab[row][j] = false;
                        }
                        Report4.this.datab[row][column] = true;
                        Report4.this.table.getModel().setValueAt(Report4.this.datac[row][column].toString(), row, 8);
                        Report4.this.table.getModel().setValueAt(Report4.this.data[row][0].toString(), row, 0);
                    }
                } else if (Report4.this.datab[row][column].booleanValue()) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(Color.white);
                    this.setForeground(Color.BLUE);
                }
            }
            if (column == 7 && Report4.this.table.getRowHeight(row) != Report4.this.ht) {
                System.out.print("row: " + row + ", col: " + column + " height" + Report4.this.ht + "\n");
                Report4.this.table.setRowHeight(row, Report4.this.ht);
            }
            return this;
        }
    }

    public class numRenderer2
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

