/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;

public class SignerInfo
implements DerEncoder {
    BigInteger version;
    X500Name issuerName;
    BigInteger certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
    }

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, PKCS9Attributes pKCS9Attributes, AlgorithmId algorithmId2, byte[] byArray, PKCS9Attributes pKCS9Attributes2) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.authenticatedAttributes = pKCS9Attributes;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
        this.unauthenticatedAttributes = pKCS9Attributes2;
    }

    public SignerInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public SignerInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray = derInputStream.getSequence(2);
        byte[] byArray = derValueArray[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, byArray));
        this.certificateSerialNumber = derValueArray[1].getBigInteger();
        DerValue derValue = derInputStream.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(derValue);
        if (bl) {
            derInputStream.getSet(0);
        } else if ((byte)derInputStream.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derInputStream);
        }
        derValue = derInputStream.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(derValue);
        this.encryptedDigest = derInputStream.getOctetString();
        if (bl) {
            derInputStream.getSet(0);
        } else if (derInputStream.available() != 0 && (byte)derInputStream.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derInputStream, true);
        }
        if (derInputStream.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.issuerName.encode(derOutputStream2);
        derOutputStream2.putInteger(this.certificateSerialNumber);
        derOutputStream.write((byte)48, derOutputStream2);
        this.digestAlgorithmId.encode(derOutputStream);
        if (this.authenticatedAttributes != null) {
            this.authenticatedAttributes.encode((byte)-96, derOutputStream);
        }
        this.digestEncryptionAlgorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes.encode((byte)-95, derOutputStream);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public X509Certificate getCertificate(PKCS7 pKCS7) throws IOException {
        return pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    public ArrayList<X509Certificate> getCertificateChain(PKCS7 pKCS7) throws IOException {
        boolean bl;
        X509Certificate x509Certificate = pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
        if (x509Certificate == null) {
            return null;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        X509Certificate[] x509CertificateArray = pKCS7.getCertificates();
        if (x509CertificateArray == null || x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            return arrayList;
        }
        Principal principal = x509Certificate.getIssuerDN();
        int n = 0;
        block0: do {
            bl = false;
            for (int i = n; i < x509CertificateArray.length; ++i) {
                if (!principal.equals(x509CertificateArray[i].getSubjectDN())) continue;
                arrayList.add(x509CertificateArray[i]);
                if (x509CertificateArray[i].getSubjectDN().equals(x509CertificateArray[i].getIssuerDN())) {
                    n = x509CertificateArray.length;
                } else {
                    principal = x509CertificateArray[i].getIssuerDN();
                    X509Certificate x509Certificate2 = x509CertificateArray[n];
                    x509CertificateArray[n] = x509CertificateArray[i];
                    x509CertificateArray[i] = x509Certificate2;
                    ++n;
                }
                bl = true;
                continue block0;
            }
        } while (bl);
        return arrayList;
    }

    private static String convertToStandardName(String string) {
        if (string.equals("SHA")) {
            return "SHA-1";
        }
        if (string.equals("SHA224")) {
            return "SHA-224";
        }
        if (string.equals("SHA256")) {
            return "SHA-256";
        }
        if (string.equals("SHA384")) {
            return "SHA-384";
        }
        if (string.equals("SHA512")) {
            return "SHA-512";
        }
        return string;
    }

    SignerInfo verify(PKCS7 pKCS7, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            byte[] byArray2;
            ContentInfo contentInfo = pKCS7.getContentInfo();
            if (byArray == null) {
                byArray = contentInfo.getContentBytes();
            }
            String string = this.getDigestAlgorithmId().getName();
            if (this.authenticatedAttributes == null) {
                byArray2 = byArray;
            } else {
                object5 = (ObjectIdentifier)this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
                if (object5 == null || !((ObjectIdentifier)object5).equals(contentInfo.contentType)) {
                    return null;
                }
                object4 = (byte[])this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (object4 == null) {
                    return null;
                }
                object3 = MessageDigest.getInstance(SignerInfo.convertToStandardName(string));
                object2 = ((MessageDigest)object3).digest(byArray);
                if (((Object)object4).length != ((Object)object2).length) {
                    return null;
                }
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (object4[i] == object2[i]) continue;
                    return null;
                }
                byArray2 = this.authenticatedAttributes.getDerEncoding();
            }
            object5 = this.getDigestEncryptionAlgorithmId().getName();
            object4 = AlgorithmId.getEncAlgFromSigAlg((String)object5);
            if (object4 != null) {
                object5 = object4;
            }
            object3 = AlgorithmId.makeSigAlg(string, (String)object5);
            object2 = Signature.getInstance((String)object3);
            X509Certificate x509Certificate = this.getCertificate(pKCS7);
            if (x509Certificate == null) {
                return null;
            }
            if (x509Certificate.hasUnsupportedCriticalExtension()) {
                throw new SignatureException("Certificate has unsupported critical extension(s)");
            }
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                try {
                    object = new KeyUsageExtension(blArray);
                }
                catch (IOException iOException) {
                    throw new SignatureException("Failed to parse keyUsage extension");
                }
                boolean bl = (Boolean)((KeyUsageExtension)object).get("digital_signature");
                boolean bl2 = (Boolean)((KeyUsageExtension)object).get("non_repudiation");
                if (!bl && !bl2) {
                    throw new SignatureException("Key usage restricted: cannot be used for digital signatures");
                }
            }
            object = x509Certificate.getPublicKey();
            ((Signature)object2).initVerify((PublicKey)object);
            ((Signature)object2).update(byArray2);
            if (((Signature)object2).verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("IO error verifying signature:\n" + iOException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("InvalidKey: " + invalidKeyException.getMessage());
        }
        return null;
    }

    SignerInfo verify(PKCS7 pKCS7) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(pKCS7, null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "Signer Info for (issuer): " + this.issuerName + "\n";
        string = string + "\tversion: " + Debug.toHexString(this.version) + "\n";
        string = string + "\tcertificateSerialNumber: " + Debug.toHexString(this.certificateSerialNumber) + "\n";
        string = string + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        if (this.authenticatedAttributes != null) {
            string = string + "\tauthenticatedAttributes: " + this.authenticatedAttributes + "\n";
        }
        string = string + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        string = string + "\tencryptedDigest: \n" + hexDumpEncoder.encodeBuffer(this.encryptedDigest) + "\n";
        if (this.unauthenticatedAttributes != null) {
            string = string + "\tunauthenticatedAttributes: " + this.unauthenticatedAttributes + "\n";
        }
        return string;
    }
}

