/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Vector;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Element;

public class XMLInteraction
extends MappedInteraction {
    protected String inputRootElementName = "";
    protected String outputRootElementName = "";

    public String getInputRootElementName() {
        return this.inputRootElementName;
    }

    public void setInputRootElementName(String inputRootElementName) {
        this.inputRootElementName = inputRootElementName;
    }

    public String getOutputRootElementName() {
        return this.outputRootElementName;
    }

    public void setOutputRootElementName(String outputRootElementName) {
        this.outputRootElementName = outputRootElementName;
    }

    public void prepare(AbstractSession session) {
        EISDescriptor descriptor;
        if (this.getInputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                descriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setInputRootElementName(descriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("input");
            }
        }
        if (this.getOutputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                descriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setOutputRootElementName(descriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("output");
            }
        }
        super.prepare(session);
    }

    public Record createInputRecord(EISAccessor accessor) {
        Record record = accessor.getEISPlatform().createDOMRecord(this.getInputRecordName(), accessor);
        Element dom = this.createInputDOM(accessor);
        accessor.getEISPlatform().setDOMInRecord(dom, record, this, accessor);
        if (record instanceof XMLRecord) {
            ((XMLRecord)record).setSession(this.getQuery().getSession());
        }
        return record;
    }

    public Element createInputDOM(EISAccessor accessor) {
        Element dom = null;
        if (this.getInputRow() != null && !this.hasArguments()) {
            if (this.getInputResultPath().length() == 0) {
                if (this.getInputRow() instanceof XMLRecord) {
                    dom = (Element)((XMLRecord)this.getInputRow()).getDOM();
                    if (!dom.getTagName().equals(this.getInputRootElementName())) {
                        XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                        parameterRow.put("/" + this.getInputRootElementName(), (Object)this.getInputRow());
                        dom = (Element)parameterRow.getDOM();
                    }
                } else {
                    XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                    for (int index = 0; index < this.getInputRow().size(); ++index) {
                        parameterRow.put(this.getInputRow().getFields().elementAt(index), this.getInputRow().getValues().elementAt(index));
                    }
                    dom = (Element)parameterRow.getDOM();
                }
            } else {
                XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                parameterRow.put(this.getInputResultPath(), (Object)this.getInputRow());
                dom = (Element)parameterRow.getDOM();
            }
        } else {
            XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
            for (int index = 0; index < this.getArgumentNames().size(); ++index) {
                String parameterName = (String)this.getArgumentNames().get(index);
                Object parameter = this.getParameters().get(index);
                if (parameter == null && this.getInputRow() != null) {
                    parameter = this.getInputRow().get(parameterName);
                }
                parameterRow.put(parameterName, parameter);
            }
            dom = (Element)parameterRow.getDOM();
        }
        return dom;
    }

    public AbstractRecord buildRow(Record record, EISAccessor accessor) {
        if (record == null) {
            return null;
        }
        AbstractRecord row = accessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, accessor);
        if (row == null) {
            return null;
        }
        if (this.getOutputResultPath().length() > 0) {
            row = (AbstractRecord)row.get(this.getOutputResultPath());
        } else if (this.hasOutputArguments()) {
            row = this.createXMLRecord(this.getOutputRootElementName());
            for (int index = 0; index < this.getOutputArgumentNames().size(); ++index) {
                DatabaseField field = (DatabaseField)this.getOutputArguments().get(index);
                row.put(field, row.get(this.getOutputArgumentNames().get(index)));
            }
        }
        return row;
    }

    public Vector buildRows(Record record, EISAccessor accessor) {
        Vector<AbstractRecord> rows = null;
        if (record == null) {
            return new Vector(0);
        }
        AbstractRecord row = accessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, accessor);
        if (this.getOutputResultPath().length() > 0) {
            Vector<AbstractRecord> values = (Vector<AbstractRecord>)row.getValues(this.getOutputResultPath());
            if (values == null) {
                values = new Vector<AbstractRecord>(0);
            }
            rows = values;
        } else {
            rows = new Vector<AbstractRecord>(1);
            rows.add(row);
        }
        return rows;
    }

    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(Helper.cr());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(Helper.cr());
        writer.write("\tproperties => ");
        writer.write(String.valueOf(this.getProperties()));
        writer.write(Helper.cr());
        writer.write("\txml => ");
        Element dom = this.createInputDOM((EISAccessor)accessor);
        EISDOMRecord record = new EISDOMRecord(dom);
        record.transformToWriter(writer);
        return writer.toString();
    }

    protected DatabaseField createField(String fieldName) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().buildField(fieldName);
        }
        return new XMLField(fieldName);
    }

    protected XMLRecord createXMLRecord(String rootName) {
        XMLRecord xmlRec;
        if (this.getQuery().getDescriptor() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
            xmlRec = (XMLRecord)((XMLObjectBuilder)this.getQuery().getDescriptor().getObjectBuilder()).createRecord(this.getInputRootElementName(), this.getQuery().getSession());
        } else {
            xmlRec = new DOMRecord(this.getInputRootElementName());
            xmlRec.setSession(this.getQuery().getSession());
        }
        return xmlRec;
    }
}

