/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.track;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmedia.track.VideoResolution;

public class VideoTrack
extends Track {
    private VideoResolution frameSize;
    private float encodedFrameRate;
    private boolean hasAlphaChannel;

    public VideoTrack(Locator locator, String name, Track.Encoding encoding, VideoResolution frameSize, float encodedFrameRate, boolean hasAlphaChannel) {
        super(locator, name, encoding);
        if (frameSize == null) {
            throw new IllegalArgumentException("frameSize == null!");
        }
        if (frameSize.width <= 0) {
            throw new IllegalArgumentException("frameSize.width <= 0!");
        }
        if (frameSize.height <= 0) {
            throw new IllegalArgumentException("frameSize.height <= 0!");
        }
        if (encodedFrameRate <= 0.0f) {
            throw new IllegalArgumentException("encodedFrameRate <= 0.0!");
        }
        this.frameSize = frameSize;
        this.encodedFrameRate = encodedFrameRate;
        this.hasAlphaChannel = hasAlphaChannel;
    }

    public boolean hasAlphaChannel() {
        return this.hasAlphaChannel;
    }

    public float getEncodedFrameRate() {
        return this.encodedFrameRate;
    }

    public VideoResolution getFrameSize() {
        return this.frameSize;
    }

    public String toString() {
        return "VideoTrack {\n    locator: " + this.getLocator() + "\n" + "    name: " + this.getName() + "\n" + "    encoding: " + (Object)((Object)this.getEncodingType()) + "\n" + "    frameSize: " + this.frameSize + "\n" + "    encodedFrameRate: " + this.encodedFrameRate + "\n" + "    hasAlphaChannel: " + this.hasAlphaChannel + "\n" + "}";
    }
}

