/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentificationVariableDeclaration
extends AbstractExpression {
    private boolean hasSpace;
    private AbstractExpression joins;
    private boolean parsingJoinExpression;
    private AbstractExpression rangeVariableDeclaration;

    IdentificationVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRangeVariableDeclaration().accept(visitor);
        this.getJoins().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRangeVariableDeclaration());
        children.add(this.getJoins());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.rangeVariableDeclaration != null) {
            children.add(this.rangeVariableDeclaration);
        }
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joins != null) {
            children.add(this.joins);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getJoins());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public Expression getJoins() {
        if (this.joins == null) {
            this.joins = this.buildNullExpression();
        }
        return this.joins;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return IdentificationVariableDeclaration.queryBNF("identification_variable_declaration");
    }

    public Expression getRangeVariableDeclaration() {
        if (this.rangeVariableDeclaration == null) {
            this.rangeVariableDeclaration = this.buildNullExpression();
        }
        return this.rangeVariableDeclaration;
    }

    public boolean hasJoins() {
        return this.joins != null && !this.joins.isNull();
    }

    public boolean hasRangeVariableDeclaration() {
        return this.rangeVariableDeclaration != null && !this.rangeVariableDeclaration.isNull();
    }

    public boolean hasSpace() {
        return this.hasSpace;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (this.parsingJoinExpression) {
            return !word.equalsIgnoreCase("INNER") && !word.equalsIgnoreCase("JOIN") && !word.equalsIgnoreCase("LEFT") && super.isParsingComplete(wordParser, word, expression);
        }
        return word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || word.equalsIgnoreCase("IN") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            this.rangeVariableDeclaration = this.parse(wordParser, (JPQLQueryBNF)IdentificationVariableDeclaration.queryBNF("range_variable_declaration"), tolerant);
        } else {
            this.rangeVariableDeclaration = new RangeVariableDeclaration(this);
            this.rangeVariableDeclaration.parse(wordParser, tolerant);
        }
        int count = wordParser.skipLeadingWhitespace();
        this.parsingJoinExpression = true;
        this.joins = this.parse(wordParser, (JPQLQueryBNF)IdentificationVariableDeclaration.queryBNF("join*"), tolerant);
        if (!this.hasJoins() && wordParser.character() != ',') {
            wordParser.moveBackward(count);
        } else {
            this.hasSpace = count > 0;
        }
    }

    void setRangeVariableDeclaration(String abstractSchemaName, String identificationVariable) {
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration(this);
        rangeVariableDeclaration.setDeclaration(abstractSchemaName, identificationVariable);
        this.rangeVariableDeclaration = rangeVariableDeclaration;
    }

    @Override
    boolean shouldParseWithFactoryFirst() {
        return this.parsingJoinExpression;
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.rangeVariableDeclaration != null) {
            this.rangeVariableDeclaration.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpace && (includeVirtual || this.hasJoins())) {
            writer.append(' ');
        }
        if (this.joins != null) {
            this.joins.toParsedText(writer, includeVirtual);
        }
    }
}

