/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.DynamicMBean2;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

public class DefaultMBeanServerInterceptor
implements MBeanServerInterceptor {
    private final transient MBeanInstantiator instantiator;
    private transient MBeanServer server = null;
    private final transient MBeanServerDelegate delegate;
    private final transient Repository repository;
    private final transient WeakHashMap<ListenerWrapper, WeakReference<ListenerWrapper>> listenerWrappers = new WeakHashMap();
    private final String domain;
    private final Set<ObjectName> beingUnregistered = new HashSet<ObjectName>();

    public DefaultMBeanServerInterceptor(MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, Repository repository) {
        if (mBeanServer == null) {
            throw new IllegalArgumentException("outer MBeanServer cannot be null");
        }
        if (mBeanServerDelegate == null) {
            throw new IllegalArgumentException("MBeanServerDelegate cannot be null");
        }
        if (mBeanInstantiator == null) {
            throw new IllegalArgumentException("MBeanInstantiator cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        this.server = mBeanServer;
        this.delegate = mBeanServerDelegate;
        this.instantiator = mBeanInstantiator;
        this.repository = repository;
        this.domain = repository.getDefaultDomain();
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(string, objectName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(string, objectName, null, true, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw EnvHelp.initCause(new IllegalArgumentException("Unexpected exception: " + instanceNotFoundException), instanceNotFoundException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, false, objectArray, stringArray);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, boolean bl, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Class<?> clazz;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
        }
        if (objectName != null) {
            if (objectName.isPattern()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
            }
            objectName = this.nonDefaultDomain(objectName);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, null, "instantiate");
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "registerMBean");
        if (bl) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + string + ", ObjectName = " + objectName);
            }
            clazz = this.instantiator.findClassWithDefaultLoaderRepository(string);
        } else if (objectName2 == null) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + string + ", ObjectName = " + objectName + ", Loader name = null");
            }
            clazz = this.instantiator.findClass(string, this.server.getClass().getClassLoader());
        } else {
            objectName2 = this.nonDefaultDomain(objectName2);
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "createMBean", "ClassName = " + string + ", ObjectName = " + objectName + ", Loader name = " + objectName2);
            }
            clazz = this.instantiator.findClass(string, objectName2);
        }
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(clazz);
        Introspector.testCreation(clazz);
        Introspector.checkCompliance(clazz);
        Object object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.server.getClass().getClassLoader());
        String string2 = DefaultMBeanServerInterceptor.getNewMBeanClassName(object);
        return this.registerObject(string2, object, objectName);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Class<?> clazz = object.getClass();
        Introspector.checkCompliance(clazz);
        String string = DefaultMBeanServerInterceptor.getNewMBeanClassName(object);
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "registerMBean");
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(clazz);
        return this.registerObject(string, object, objectName);
    }

    private static String getNewMBeanClassName(Object object) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            String string;
            DynamicMBean dynamicMBean = (DynamicMBean)object;
            try {
                string = dynamicMBean.getMBeanInfo().getClassName();
            }
            catch (Exception exception) {
                NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException("Bad getMBeanInfo()");
                notCompliantMBeanException.initCause(exception);
                throw notCompliantMBeanException;
            }
            if (string == null) {
                throw new NotCompliantMBeanException("MBeanInfo has null class name");
            }
            return string;
        }
        return object.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to unregister the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        Set<ObjectName> set = this.beingUnregistered;
        synchronized (set) {
            while (this.beingUnregistered.contains(objectName)) {
                try {
                    this.beingUnregistered.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new MBeanRegistrationException(interruptedException, interruptedException.toString());
                }
            }
            this.beingUnregistered.add(objectName);
        }
        try {
            this.exclusiveUnregisterMBean(objectName);
        }
        finally {
            set = this.beingUnregistered;
            synchronized (set) {
                this.beingUnregistered.remove(objectName);
                this.beingUnregistered.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exclusiveUnregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "unregisterMBean");
        if (dynamicMBean instanceof MBeanRegistration) {
            DefaultMBeanServerInterceptor.preDeregisterInvoke((MBeanRegistration)((Object)dynamicMBean));
        }
        Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
        ResourceContext resourceContext = this.unregisterFromRepository(object, dynamicMBean, objectName);
        try {
            if (dynamicMBean instanceof MBeanRegistration) {
                DefaultMBeanServerInterceptor.postDeregisterInvoke(objectName, (MBeanRegistration)((Object)dynamicMBean));
            }
        }
        finally {
            resourceContext.done();
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        objectName = this.nonDefaultDomain(objectName);
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "getObjectInstance");
        String string = DefaultMBeanServerInterceptor.getClassName(dynamicMBean);
        return new ObjectInstance(objectName, string);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "queryMBeans");
            Set<ObjectInstance> set = this.queryMBeansImpl(objectName, null);
            HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>(set.size());
            for (ObjectInstance objectInstance : set) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(objectInstance.getClassName(), null, objectInstance.getObjectName(), "queryMBeans");
                    hashSet.add(objectInstance);
                }
                catch (SecurityException securityException) {}
            }
            return this.filterListOfObjectInstances(hashSet, queryExp);
        }
        return this.queryMBeansImpl(objectName, queryExp);
    }

    private Set<ObjectInstance> queryMBeansImpl(ObjectName objectName, QueryExp queryExp) {
        Set<NamedObject> set = this.repository.query(objectName, queryExp);
        return this.objectInstancesFromFilteredNamedObjects(set, queryExp);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        Set<ObjectName> set;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "queryNames");
            Set<ObjectInstance> set2 = this.queryMBeansImpl(objectName, null);
            HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>(set2.size());
            for (ObjectInstance object2 : set2) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(object2.getClassName(), null, object2.getObjectName(), "queryNames");
                    hashSet.add(object2);
                }
                catch (SecurityException objectInstance) {}
            }
            Set<ObjectInstance> set3 = this.filterListOfObjectInstances(hashSet, queryExp);
            set = new HashSet<ObjectName>(set3.size());
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                ObjectInstance objectInstance = (ObjectInstance)iterator.next();
                set.add(objectInstance.getObjectName());
            }
        } else {
            set = this.queryNamesImpl(objectName, queryExp);
        }
        return set;
    }

    private Set<ObjectName> queryNamesImpl(ObjectName objectName, QueryExp queryExp) {
        Set<NamedObject> set = this.repository.query(objectName, queryExp);
        return this.objectNamesFromFilteredNamedObjects(set, queryExp);
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        objectName = this.nonDefaultDomain(objectName);
        return this.repository.contains(objectName);
    }

    @Override
    public String[] getDomains() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "getDomains");
            String[] stringArray = this.repository.getDomains();
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ObjectName objectName = Util.newObjectName(stringArray[i] + ":x=x");
                    DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, objectName, "getDomains");
                    arrayList.add(stringArray[i]);
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.repository.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getAttribute", "Attribute = " + string + ", ObjectName = " + objectName);
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, string, objectName, "getAttribute");
        try {
            return dynamicMBean.getAttribute(string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(throwable);
            throw new AssertionError();
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        String[] stringArray2;
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getAttributes", "ObjectName = " + objectName);
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            stringArray2 = stringArray;
        } else {
            String string = DefaultMBeanServerInterceptor.getClassName(dynamicMBean);
            DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "getAttribute");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string2 : stringArray) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(string, string2, objectName, "getAttribute");
                    arrayList.add(string2);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        try {
            return dynamicMBean.getAttributes(stringArray2);
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.rethrow(throwable);
            throw new AssertionError();
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "setAttribute", "ObjectName = " + objectName + ", Attribute = " + attribute.getName());
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, attribute.getName(), objectName, "setAttribute");
        try {
            dynamicMBean.setAttribute(attribute);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(throwable);
            throw new AssertionError();
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList2;
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            attributeList2 = attributeList;
        } else {
            String string = DefaultMBeanServerInterceptor.getClassName(dynamicMBean);
            DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "setAttribute");
            attributeList2 = new AttributeList(attributeList.size());
            for (Attribute attribute : attributeList.asList()) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(string, attribute.getName(), objectName, "setAttribute");
                    attributeList2.add(attribute);
                }
                catch (SecurityException securityException) {}
            }
        }
        try {
            return dynamicMBean.setAttributes(attributeList2);
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.rethrow(throwable);
            throw new AssertionError();
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        objectName = this.nonDefaultDomain(objectName);
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, string, objectName, "invoke");
        try {
            return dynamicMBean.invoke(string, objectArray, stringArray);
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.rethrowMaybeMBeanException(throwable);
            throw new AssertionError();
        }
    }

    private static void rethrow(Throwable throwable) throws ReflectionException {
        try {
            throw throwable;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw runtimeOperationsException;
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, runtimeException.toString());
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, error.toString());
        }
        catch (Throwable throwable2) {
            throw new RuntimeException("Unexpected exception", throwable2);
        }
    }

    private static void rethrowMaybeMBeanException(Throwable throwable) throws ReflectionException, MBeanException {
        if (throwable instanceof MBeanException) {
            throw (MBeanException)throwable;
        }
        DefaultMBeanServerInterceptor.rethrow(throwable);
    }

    private ObjectInstance registerObject(String string, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean");
        }
        DynamicMBean dynamicMBean = Introspector.makeDynamicMBean(object);
        return this.registerDynamicMBean(string, dynamicMBean, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInstance registerDynamicMBean(String string, DynamicMBean dynamicMBean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        objectName = this.nonDefaultDomain(objectName);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "registerMBean", "ObjectName = " + objectName);
        }
        ObjectName objectName2 = DefaultMBeanServerInterceptor.preRegister(dynamicMBean, this.server, objectName);
        boolean bl = false;
        boolean bl2 = false;
        ResourceContext resourceContext = null;
        try {
            if (dynamicMBean instanceof DynamicMBean2) {
                try {
                    ((DynamicMBean2)dynamicMBean).preRegister2(this.server, objectName2);
                    bl2 = true;
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    if (exception instanceof InstanceAlreadyExistsException) {
                        throw (InstanceAlreadyExistsException)exception;
                    }
                    throw new RuntimeException(exception);
                }
            }
            if (objectName2 != objectName && objectName2 != null) {
                objectName2 = ObjectName.getInstance(this.nonDefaultDomain(objectName2));
            }
            DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName2, "registerMBean");
            if (objectName2 == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No object name specified");
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean");
            }
            Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
            resourceContext = this.registerWithRepository(object, dynamicMBean, objectName2);
            bl2 = false;
            bl = true;
        }
        finally {
            try {
                DefaultMBeanServerInterceptor.postRegister(objectName2, dynamicMBean, bl, bl2);
            }
            finally {
                if (bl && resourceContext != null) {
                    resourceContext.done();
                }
            }
        }
        return new ObjectInstance(objectName2, string);
    }

    private static void throwMBeanRegistrationException(Throwable throwable, String string) throws MBeanRegistrationException {
        if (throwable instanceof RuntimeException) {
            throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown " + string);
        }
        if (throwable instanceof Error) {
            throw new RuntimeErrorException((Error)throwable, "Error thrown " + string);
        }
        if (throwable instanceof MBeanRegistrationException) {
            throw (MBeanRegistrationException)throwable;
        }
        if (throwable instanceof Exception) {
            throw new MBeanRegistrationException((Exception)throwable, "Exception thrown " + string);
        }
        throw new RuntimeException(throwable);
    }

    private static ObjectName preRegister(DynamicMBean dynamicMBean, MBeanServer mBeanServer, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName2 = null;
        try {
            if (dynamicMBean instanceof MBeanRegistration) {
                objectName2 = ((MBeanRegistration)((Object)dynamicMBean)).preRegister(mBeanServer, objectName);
            }
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.throwMBeanRegistrationException(throwable, "in preRegister method");
        }
        if (objectName2 != null) {
            return objectName2;
        }
        return objectName;
    }

    private static void postRegister(ObjectName objectName, DynamicMBean dynamicMBean, boolean bl, boolean bl2) {
        if (bl2 && dynamicMBean instanceof DynamicMBean2) {
            ((DynamicMBean2)dynamicMBean).registerFailed();
        }
        try {
            if (dynamicMBean instanceof MBeanRegistration) {
                ((MBeanRegistration)((Object)dynamicMBean)).postRegister(bl);
            }
        }
        catch (RuntimeException runtimeException) {
            JmxProperties.MBEANSERVER_LOGGER.fine("While registering MBean [" + objectName + "]: " + "Exception thrown by postRegister: " + "rethrowing <" + runtimeException + ">, but keeping the MBean registered");
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postRegister method: rethrowing <" + runtimeException + ">, but keeping the MBean registered");
        }
        catch (Error error) {
            JmxProperties.MBEANSERVER_LOGGER.fine("While registering MBean [" + objectName + "]: " + "Error thrown by postRegister: " + "rethrowing <" + error + ">, but keeping the MBean registered");
            throw new RuntimeErrorException(error, "Error thrown in postRegister method: rethrowing <" + error + ">, but keeping the MBean registered");
        }
    }

    private static void preDeregisterInvoke(MBeanRegistration mBeanRegistration) throws MBeanRegistrationException {
        try {
            mBeanRegistration.preDeregister();
        }
        catch (Throwable throwable) {
            DefaultMBeanServerInterceptor.throwMBeanRegistrationException(throwable, "in preDeregister method");
        }
    }

    private static void postDeregisterInvoke(ObjectName objectName, MBeanRegistration mBeanRegistration) {
        try {
            mBeanRegistration.postDeregister();
        }
        catch (RuntimeException runtimeException) {
            JmxProperties.MBEANSERVER_LOGGER.fine("While unregistering MBean [" + objectName + "]: " + "Exception thrown by postDeregister: " + "rethrowing <" + runtimeException + ">, although the MBean is succesfully " + "unregistered");
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postDeregister method: rethrowing <" + runtimeException + ">, although the MBean is sucessfully unregistered");
        }
        catch (Error error) {
            JmxProperties.MBEANSERVER_LOGGER.fine("While unregistering MBean [" + objectName + "]: " + "Error thrown by postDeregister: " + "rethrowing <" + error + ">, although the MBean is succesfully " + "unregistered");
            throw new RuntimeErrorException(error, "Error thrown in postDeregister method: rethrowing <" + error + ">, although the MBean is sucessfully unregistered");
        }
    }

    private DynamicMBean getMBean(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to get an MBean");
        }
        DynamicMBean dynamicMBean = this.repository.retrieve(objectName);
        if (dynamicMBean == null) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "getMBean", objectName + " : Found no object");
            }
            throw new InstanceNotFoundException(objectName.toString());
        }
        return dynamicMBean;
    }

    private static Object getResource(DynamicMBean dynamicMBean) {
        if (dynamicMBean instanceof DynamicMBean2) {
            return ((DynamicMBean2)dynamicMBean).getResource();
        }
        return dynamicMBean;
    }

    private ObjectName nonDefaultDomain(ObjectName objectName) {
        if (objectName == null || objectName.getDomain().length() > 0) {
            return objectName;
        }
        String string = this.domain + objectName;
        return Util.newObjectName(string);
    }

    @Override
    public String getDefaultDomain() {
        return this.domain;
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addNotificationListener", "ObjectName = " + objectName);
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "addNotificationListener");
        NotificationBroadcaster notificationBroadcaster = DefaultMBeanServerInterceptor.getNotificationBroadcaster(objectName, dynamicMBean, NotificationBroadcaster.class);
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, dynamicMBean, true);
        notificationBroadcaster.addNotificationListener(notificationListener2, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.getMBean(objectName2);
        Object object2 = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
        if (!(object2 instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName2.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addNotificationListener", "ObjectName = " + objectName + ", Listener = " + objectName2);
        }
        this.server.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, null, null, true);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, notificationFilter, object, false);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListener(objectName2);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + objectName + ", Listener = " + objectName2);
        }
        this.server.removeNotificationListener(objectName, notificationListener);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListener(objectName2);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + objectName + ", Listener = " + objectName2);
        }
        this.server.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    private NotificationListener getListener(ObjectName objectName) throws ListenerNotFoundException {
        DynamicMBean dynamicMBean;
        try {
            dynamicMBean = this.getMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw EnvHelp.initCause(new ListenerNotFoundException(instanceNotFoundException.getMessage()), instanceNotFoundException);
        }
        Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
        if (!(object instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
            String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + NotificationListener.class.getName();
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        return (NotificationListener)object;
    }

    private void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, boolean bl) throws InstanceNotFoundException, ListenerNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "removeNotificationListener", "ObjectName = " + objectName);
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "removeNotificationListener");
        Class clazz = bl ? NotificationBroadcaster.class : NotificationEmitter.class;
        NotificationBroadcaster notificationBroadcaster = DefaultMBeanServerInterceptor.getNotificationBroadcaster(objectName, dynamicMBean, clazz);
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, dynamicMBean, false);
        if (notificationListener2 == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (bl) {
            notificationBroadcaster.removeNotificationListener(notificationListener2);
        } else {
            NotificationEmitter notificationEmitter = (NotificationEmitter)notificationBroadcaster;
            notificationEmitter.removeNotificationListener(notificationListener2, notificationFilter, object);
        }
    }

    private static <T extends NotificationBroadcaster> T getNotificationBroadcaster(ObjectName objectName, Object object, Class<T> clazz) {
        if (clazz.isInstance(object)) {
            return (T)((NotificationBroadcaster)clazz.cast(object));
        }
        if (object instanceof DynamicMBean2) {
            object = ((DynamicMBean2)object).getResource();
        }
        if (clazz.isInstance(object)) {
            return (T)((NotificationBroadcaster)clazz.cast(object));
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
        String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + clazz.getName();
        throw new RuntimeOperationsException(illegalArgumentException, string);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mBeanInfo;
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        try {
            mBeanInfo = dynamicMBean.getMBeanInfo();
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException;
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "getMBeanInfo threw RuntimeException");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "getMBeanInfo threw Error");
        }
        if (mBeanInfo == null) {
            throw new JMRuntimeException("MBean " + objectName + "has no MBeanInfo");
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(mBeanInfo.getClassName(), null, objectName, "getMBeanInfo");
        return mBeanInfo;
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "isInstanceOf");
        try {
            String string2;
            Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
            String string3 = string2 = object instanceof DynamicMBean ? DefaultMBeanServerInterceptor.getClassName((DynamicMBean)object) : object.getClass().getName();
            if (string2.equals(string)) {
                return true;
            }
            ClassLoader classLoader = object.getClass().getClassLoader();
            Class<?> clazz = Class.forName(string, false, classLoader);
            if (clazz.isInstance(object)) {
                return true;
            }
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Exception exception) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, DefaultMBeanServerInterceptor.class.getName(), "isInstanceOf", "Exception calling isInstanceOf", exception);
            }
            return false;
        }
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "getClassLoaderFor");
        return DefaultMBeanServerInterceptor.getResource(dynamicMBean).getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission((String)null, null, null, "getClassLoader");
            return this.server.getClass().getClassLoader();
        }
        DynamicMBean dynamicMBean = this.getMBean(objectName);
        DefaultMBeanServerInterceptor.checkMBeanPermission(dynamicMBean, null, objectName, "getClassLoader");
        Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
        if (!(object instanceof ClassLoader)) {
            throw new InstanceNotFoundException(objectName.toString() + " is not a classloader");
        }
        return (ClassLoader)object;
    }

    private void sendNotification(String string, ObjectName objectName) {
        MBeanServerNotification mBeanServerNotification = new MBeanServerNotification(string, (Object)MBeanServerDelegate.DELEGATE_NAME, 0L, objectName);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "sendNotification", string + " " + objectName);
        }
        this.delegate.sendNotification(mBeanServerNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectName> objectNamesFromFilteredNamedObjects(Set<NamedObject> set, QueryExp queryExp) {
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        if (queryExp == null) {
            for (NamedObject namedObject : set) {
                hashSet.add(namedObject.getName());
            }
        } else {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            queryExp.setMBeanServer(this.server);
            try {
                for (NamedObject namedObject : set) {
                    boolean bl;
                    try {
                        bl = queryExp.apply(namedObject.getName());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) continue;
                    hashSet.add(namedObject.getName());
                }
            }
            finally {
                queryExp.setMBeanServer(mBeanServer);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectInstance> objectInstancesFromFilteredNamedObjects(Set<NamedObject> set, QueryExp queryExp) {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        if (queryExp == null) {
            for (NamedObject namedObject : set) {
                DynamicMBean dynamicMBean = namedObject.getObject();
                String string = DefaultMBeanServerInterceptor.safeGetClassName(dynamicMBean);
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        } else {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            queryExp.setMBeanServer(this.server);
            try {
                for (NamedObject namedObject : set) {
                    boolean bl;
                    DynamicMBean dynamicMBean = namedObject.getObject();
                    try {
                        bl = queryExp.apply(namedObject.getName());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) continue;
                    String string = DefaultMBeanServerInterceptor.safeGetClassName(dynamicMBean);
                    hashSet.add(new ObjectInstance(namedObject.getName(), string));
                }
            }
            finally {
                queryExp.setMBeanServer(mBeanServer);
            }
        }
        return hashSet;
    }

    private static String safeGetClassName(DynamicMBean dynamicMBean) {
        try {
            return DefaultMBeanServerInterceptor.getClassName(dynamicMBean);
        }
        catch (Exception exception) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, DefaultMBeanServerInterceptor.class.getName(), "safeGetClassName", "Exception getting MBean class name", exception);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectInstance> filterListOfObjectInstances(Set<ObjectInstance> set, QueryExp queryExp) {
        if (queryExp == null) {
            return set;
        }
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        for (ObjectInstance objectInstance : set) {
            boolean bl = false;
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            queryExp.setMBeanServer(this.server);
            try {
                bl = queryExp.apply(objectInstance.getObjectName());
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                queryExp.setMBeanServer(mBeanServer);
            }
            if (!bl) continue;
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener notificationListener, ObjectName objectName, DynamicMBean dynamicMBean, boolean bl) {
        Object object = DefaultMBeanServerInterceptor.getResource(dynamicMBean);
        ListenerWrapper listenerWrapper = new ListenerWrapper(notificationListener, objectName, object);
        WeakHashMap<ListenerWrapper, WeakReference<ListenerWrapper>> weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener notificationListener2;
            WeakReference<ListenerWrapper> weakReference = this.listenerWrappers.get(listenerWrapper);
            if (weakReference != null && (notificationListener2 = (NotificationListener)weakReference.get()) != null) {
                return notificationListener2;
            }
            if (bl) {
                weakReference = new WeakReference<ListenerWrapper>(listenerWrapper);
                this.listenerWrappers.put(listenerWrapper, weakReference);
                return listenerWrapper;
            }
            return null;
        }
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String getClassName(DynamicMBean dynamicMBean) {
        if (dynamicMBean instanceof DynamicMBean2) {
            return ((DynamicMBean2)dynamicMBean).getClassName();
        }
        return dynamicMBean.getMBeanInfo().getClassName();
    }

    private static void checkMBeanPermission(DynamicMBean dynamicMBean, String string, ObjectName objectName, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(DefaultMBeanServerInterceptor.safeGetClassName(dynamicMBean), string, objectName, string2);
        }
    }

    private static void checkMBeanPermission(String string, String string2, ObjectName objectName, String string3) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanPermission mBeanPermission = new MBeanPermission(string, string2, objectName, string3);
            securityManager.checkPermission(mBeanPermission);
        }
    }

    private static void checkMBeanTrustPermission(final Class<?> clazz) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanTrustPermission mBeanTrustPermission = new MBeanTrustPermission("register");
            PrivilegedAction<ProtectionDomain> privilegedAction = new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    return clazz.getProtectionDomain();
                }
            };
            ProtectionDomain protectionDomain = AccessController.doPrivileged(privilegedAction);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            securityManager.checkPermission(mBeanTrustPermission, accessControlContext);
        }
    }

    private ResourceContext registerWithRepository(Object object, DynamicMBean dynamicMBean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ResourceContext resourceContext = this.makeResourceContextFor(object, objectName);
        this.repository.addMBean(dynamicMBean, objectName, resourceContext);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "addObject", "Send create notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", objectName);
        return resourceContext;
    }

    private ResourceContext unregisterFromRepository(Object object, DynamicMBean dynamicMBean, ObjectName objectName) throws InstanceNotFoundException {
        ResourceContext resourceContext = this.makeResourceContextFor(object, objectName);
        this.repository.remove(objectName, resourceContext);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, DefaultMBeanServerInterceptor.class.getName(), "unregisterMBean", "Send delete notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.unregistered", objectName);
        return resourceContext;
    }

    private void addClassLoader(ClassLoader classLoader, ObjectName objectName) {
        ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.getInstantiatorCLR();
        if (modifiableClassLoaderRepository == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean as a class loader");
        }
        modifiableClassLoaderRepository.addClassLoader(objectName, classLoader);
    }

    private void removeClassLoader(ClassLoader classLoader, ObjectName objectName) {
        ModifiableClassLoaderRepository modifiableClassLoaderRepository;
        if (classLoader != this.server.getClass().getClassLoader() && (modifiableClassLoaderRepository = this.getInstantiatorCLR()) != null) {
            modifiableClassLoaderRepository.removeClassLoader(objectName);
        }
    }

    private ResourceContext createClassLoaderContext(final ClassLoader classLoader, final ObjectName objectName) {
        return new ResourceContext(){

            @Override
            public void registering() {
                DefaultMBeanServerInterceptor.this.addClassLoader(classLoader, objectName);
            }

            @Override
            public void unregistered() {
                DefaultMBeanServerInterceptor.this.removeClassLoader(classLoader, objectName);
            }

            @Override
            public void done() {
            }
        };
    }

    private ResourceContext makeResourceContextFor(Object object, ObjectName objectName) {
        if (object instanceof ClassLoader) {
            return this.createClassLoaderContext((ClassLoader)object, objectName);
        }
        return ResourceContext.NONE;
    }

    private ModifiableClassLoaderRepository getInstantiatorCLR() {
        return AccessController.doPrivileged(new PrivilegedAction<ModifiableClassLoaderRepository>(){

            @Override
            public ModifiableClassLoaderRepository run() {
                return DefaultMBeanServerInterceptor.this.instantiator != null ? DefaultMBeanServerInterceptor.this.instantiator.getClassLoaderRepository() : null;
            }
        });
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener notificationListener, ObjectName objectName, Object object) {
            this.listener = notificationListener;
            this.name = objectName;
            this.mbean = object;
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, object);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper listenerWrapper = (ListenerWrapper)object;
            return listenerWrapper.listener == this.listener && listenerWrapper.mbean == this.mbean && listenerWrapper.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }

    private static interface ResourceContext
    extends Repository.RegistrationContext {
        public static final ResourceContext NONE = new ResourceContext(){

            @Override
            public void done() {
            }

            @Override
            public void registering() {
            }

            @Override
            public void unregistered() {
            }
        };

        public void done();
    }
}

