/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Components;
import demo.Exposure;
import demo.Template;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.shop.tools.CustomerRootNode;
import org.shop.tools.EntityService;
import org.shop.tools.TemplateChildFactory;
import org.shop.tools.ToolsTopComponent;

public class Report2
extends JFrame
implements ExplorerManager.Provider {
    private static String[][] dataField;
    private static ExplorerManager em;
    private static String RootName;
    Integer fntDecr1 = 0;
    Integer client;
    Integer polnum;
    String PU;
    OutlineView ov;
    List<Template> resultList;
    String[][] prop2 = new String[][]{{"s00", "description", "For Internal Use", ""}, {"s01", "policynumber", "<html>Quote<br>Number</html>", ""}, {"s02", "description", "<html>Policy<br>Number</html>", "rep5policy"}, {"s03", "description", "<html>Policy<br>Name</html>", "rep5name"}, {"s04", "clientname", "<html>Client<br>Name</html>", ""}, {"s05", "underwriter", "Underwriter", ""}, {"s06", "usersgroup", "Company", ""}, {"s07", "description", "Status", "rep3chk"}, {"i0", "version", "Version", ""}, {"s08", "pdata1", "<html>Effective<br>Dates</html>", ""}, {"s09", "pdata2", "<html>Received<br>Dates</html>", ""}, {"s10", "description", "<html>Quote<br>State</html>", ""}, {"s11", "comments", "Comments", ""}, {"f0", "units", "Units", ""}, {"f1", "ttimod", "<html>Indicated<br>MOD</html>", ""}, {"f2", "ttfmod", "<html>Final<br>MOD</html>", ""}, {"f3", "ttcprm", "<html>Current<br>Premium</html>", ""}, {"f4", "ttiprm", "<html>Indicated<br>Premium</html>", ""}, {"f5", "ttfprm", "<html>Final<br>Premium</html>", ""}};
    String[] prop;
    ToolsTopComponent tc;
    JFrame jf;
    Double frmht;
    Double frmwt;
    int page = 0;
    JButton bClose;
    JButton bPrint;
    JButton bReset;
    JButton bScroll;
    JButton bUpdate;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel jp;
    private JTable table;
    Timer timer3;
    Boolean keepPrinting = true;

    public Report2(String pu, Integer clnt, String usersgroup, ToolsTopComponent tc) {
        int i;
        this.tc = tc;
        this.initComponents();
        this.jf = this;
        this.frmht = this.jf.getSize().getHeight();
        this.frmwt = this.jf.getSize().getWidth();
        this.bScroll.addActionListener(new ExposureListener());
        this.bScroll.setVisible(false);
        this.setTitle("All Fleet Summary");
        this.PU = pu;
        this.client = clnt;
        this.bClose.addActionListener(new ExposureListener());
        this.bPrint.addActionListener(new ExposureListener());
        this.bUpdate.addActionListener(new ExposureListener());
        this.bReset.addActionListener(new ExposureListener());
        this.ov = new OutlineView("<html>Row<br>Number</html>");
        Integer j = 0;
        this.prop = new String[this.prop2.length * 2 - 2];
        for (int i2 = 1; i2 < this.prop2.length; ++i2) {
            Integer n = j;
            Integer n2 = j = Integer.valueOf(j + 1);
            this.prop[n.intValue()] = this.prop2[i2][0];
            n = j;
            n2 = j = Integer.valueOf(j + 1);
            this.prop[n.intValue()] = this.prop2[i2][2];
        }
        this.ov.setPropertyColumns(this.prop);
        this.ov.getOutline().getColumnModel().getColumn(0).setWidth(0);
        TableColumnModel mc = this.ov.getOutline().getColumnModel();
        mc.getColumn(0).setCellRenderer(new numRenderer4());
        for (i = 1; i < 13; ++i) {
            if (i == 8) {
                mc.getColumn(i).setCellRenderer(new numRenderer2((Integer)3));
                continue;
            }
            mc.getColumn(i).setCellRenderer(new numRenderer2((Integer)4));
        }
        mc.getColumn(13).setCellRenderer(new numRenderer2((Integer)5));
        for (i = 14; i < 16; ++i) {
            mc.getColumn(i).setCellRenderer(new numRenderer2((Integer)2));
        }
        for (i = 16; i < 19; ++i) {
            mc.getColumn(i).setCellRenderer(new numRenderer2((Integer)1));
        }
        for (i = 0; i < 19; ++i) {
            if (i < 13) {
                mc.getColumn(i).setHeaderRenderer(new HeaderRenderer(new JTable(), 2));
                continue;
            }
            mc.getColumn(i).setHeaderRenderer(new HeaderRenderer(new JTable(), 2));
        }
        this.ov.getOutline().setRootVisible(false);
        this.ov.getOutline().setFullyNonEditable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jp, "North");
        this.add((Component)this.ov, "Center");
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultListversion = entityManager.createNamedQuery("Components.findnameany").setParameter("client", (Object)this.client).setParameter("version", (Object)0).setParameter("name", (Object)"Version").getResultList();
        List rl = entityManager.createNamedQuery("Exposure").setParameter("client", (Object)this.client).getResultList();
        this.resultList = new ArrayList<Template>();
        String[] usersgroup2 = new String[]{};
        if (usersgroup != null) {
            usersgroup2 = usersgroup.split(":", -99);
        }
        if (usersgroup2.length > 1) {
            for (Exposure expo : rl) {
                String[] usersgroup1 = Report2.getString(expo, "usersgroup").split(":", -99);
                if (!this.validUser(usersgroup2[0], usersgroup1[0]).booleanValue()) continue;
                SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
                SimpleDateFormat dfnew = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    if (!Report2.getString(expo, "Pdata1").isEmpty()) {
                        expo.setPdata1(dfnew.format(df.parse(Report2.getString(expo, "Pdata1"))));
                    }
                    if (!Report2.getString(expo, "Pdata2").isEmpty()) {
                        expo.setPdata2(dfnew.format(df.parse(Report2.getString(expo, "Pdata2"))));
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                Template temp = new Template();
                temp.setPolnum(Integer.valueOf(0));
                temp.setNumber(Integer.valueOf(0));
                temp.setS00(expo.getDescription());
                String Desc = "";
                if (expo.getCellin() == null || expo.getCellin().equals(0)) {
                    Desc = "In Progress";
                } else if (expo.getCellin().equals(1) || expo.getCellin().equals(2)) {
                    Desc = "Frozen";
                } else if (expo.getCellin().equals(3)) {
                    Desc = "Hidden";
                } else if (expo.getCellin().equals(4)) {
                    Desc = "Bound";
                }
                expo.setDescription(Desc);
                expo.setTtiprm(Float.valueOf(this.getFloat(expo, "Ttcprm").floatValue() * this.getFloat(expo, "Ttimod").floatValue()));
                if (this.getInteger(expo, "Cell01in") > 1) {
                    expo.setComments("Individually Rate");
                }
                expo.setUsersgroup(usersgroup1[0]);
                for (Components vers : resultListversion) {
                    if (!vers.getLinked().equals(usersgroup1[0])) continue;
                    expo.setUsersgroup(vers.getInitvalue());
                    break;
                }
                for (int i3 = 1; i3 < this.prop2.length; ++i3) {
                    String field = this.prop2[i3][0];
                    if (field.indexOf("s") == 0) {
                        this.setString(temp, this.prop2[i3][0], Report2.getString(expo, this.prop2[i3][1]));
                        continue;
                    }
                    if (field.indexOf("i") == 0) {
                        Report2.setInteger(temp, this.prop2[i3][0], this.getInteger(expo, this.prop2[i3][1]));
                        continue;
                    }
                    if (field.indexOf("f") != 0) continue;
                    Report2.setFloat(temp, this.prop2[i3][0], this.getFloat(expo, this.prop2[i3][1]));
                }
                this.resultList.add(temp);
            }
            this.addLabels();
        }
        this.fireAction(this.bReset, "");
        this.hide(new String[]{"s03", "i0", "s05", "s10"});
    }

    Boolean validUser(String sup, String grp) {
        TreeMap hm = (TreeMap)this.tc.getClientProperty("Usersgroup");
        if (hm != null) {
            return this.i2b((Integer)hm.get("[" + sup + "][" + grp + "]"));
        }
        return false;
    }

    public void hide(String[] arr) {
        HashMap<Integer, Integer> unsortMap = new HashMap<Integer, Integer>();
        block0: for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < this.prop.length; j += 2) {
                if (!arr[i].equals(this.prop[j])) continue;
                Integer cnt = j / 2;
                unsortMap.put(cnt + 1, cnt + 1);
                continue block0;
            }
        }
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        treeMap.putAll(unsortMap);
        System.out.println("Unsort Map......");
        Report2.printMap(unsortMap);
        System.out.println("\nSorted Map......");
        Report2.printMap(treeMap);
        for (Integer c : treeMap.keySet()) {
            this.hideCol(c);
            System.out.println("key " + c);
        }
    }

    public static void printMap(Map<Integer, Integer> map) {
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            System.out.println("Key : " + entry.getKey() + " Value : " + entry.getValue());
        }
    }

    public void hideCol(Integer in) {
        TableColumnModel columnModel = this.ov.getOutline().getColumnModel();
        ETableColumn column = (ETableColumn)columnModel.getColumn(in);
        ((ETableColumnModel)columnModel).setColumnHidden((TableColumn)column, true);
    }

    public static void refreshNode(List<Template> rl) {
        CustomerRootNode crn = new CustomerRootNode(Children.create((ChildFactory)new TemplateChildFactory(rl), (boolean)true), RootName);
        em.setRootContext((Node)crn);
    }

    public void addLabels() {
        if (this.resultList.size() > 0) {
            Integer i = 0;
            for (Template pol : this.resultList) {
                String[] desarray = this.initSplit(pol.getS00());
                for (int j = 0; j < this.prop2.length; ++j) {
                    if (this.prop2[j][3].isEmpty()) continue;
                    String str = this.SrchPair(desarray, this.prop2[j][3]);
                    str = str.replaceAll("=", ":");
                    if (this.prop2[j][3].equals("rep3chk")) {
                        if (str.equals("1")) {
                            str = "Quote";
                        } else if (str.equals("2")) {
                            str = "New";
                        } else if (str.equals("3")) {
                            str = "Renew";
                        }
                    }
                    this.setString(pol, this.prop2[j][0], str);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    public List<Exposure> addLabels(List<Exposure> rl) {
        if (rl.size() > 0) {
            String[] srch = new String[]{"rep5policy"};
            String[] dummy = new String[]{"cell11in"};
            Integer num = 5;
            dataField = new String[rl.size()][num + 1 + srch.length];
            Integer i = 0;
            for (Exposure pol : rl) {
                String[] desarray = this.initSplit(pol.getDescription());
                for (int j = num + 1; j < num + 1 + srch.length; ++j) {
                    String str = this.SrchPair(desarray, srch[j - (num + 1)]);
                    Report2.dataField[i.intValue()][j] = str.replaceAll("=", ":");
                    Report2.setInteger(pol, dummy[j - (num + 1)], i);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return rl;
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    String[] initSplit(String str) {
        String[] blank = new String[]{};
        String[] lineSplit = new String[]{};
        if (str.length() == 0) {
            lineSplit = blank;
        } else {
            lineSplit = str.substring(1).split(":", -99);
            if (lineSplit.length < 2) {
                lineSplit = blank;
            }
        }
        return lineSplit;
    }

    String SrchPair(String[] arr, String srch) {
        String found = "";
        Object spt = null;
        for (int i = 1; i < arr.length; i += 2) {
            if (!srch.equals(arr[i - 1])) continue;
            return arr[i];
        }
        return found;
    }

    void PopulateTable(List<Template> resultList) {
        int i;
        Object[] head = new String[]{"", "Total", "Change from Current"};
        Object[][] data = new Object[4][3];
        data[0][0] = "Units";
        data[1][0] = "Current";
        data[2][0] = "Indicated";
        data[3][0] = "Proposed";
        Float curr = Float.valueOf(0.0f);
        Float ind = Float.valueOf(0.0f);
        Float prop = Float.valueOf(0.0f);
        Float units = Float.valueOf(0.0f);
        for (Template rg : resultList) {
            units = Float.valueOf(units.floatValue() + this.getFloat(rg, "f0").floatValue());
            curr = Float.valueOf(curr.floatValue() + this.getFloat(rg, "f3").floatValue());
            ind = Float.valueOf(ind.floatValue() + this.getFloat(rg, "f4").floatValue());
            prop = Float.valueOf(prop.floatValue() + this.getFloat(rg, "f5").floatValue());
        }
        NumberFormat formatcur = NumberFormat.getCurrencyInstance();
        formatcur.setMaximumFractionDigits(0);
        NumberFormat formatnum = NumberFormat.getNumberInstance();
        formatnum.setMaximumFractionDigits(1);
        formatnum.setMinimumFractionDigits(1);
        NumberFormat formatper = NumberFormat.getPercentInstance();
        formatper.setMinimumFractionDigits(1);
        data[0][1] = formatnum.format(units);
        data[1][1] = formatcur.format(curr);
        data[2][1] = formatcur.format(ind);
        data[3][1] = formatcur.format(prop);
        if (curr.floatValue() != 0.0f) {
            data[2][2] = formatper.format(ind.floatValue() / curr.floatValue() - 1.0f);
            data[3][2] = formatper.format(prop.floatValue() / curr.floatValue() - 1.0f);
        }
        DefaultTableModel tab1 = new DefaultTableModel(data, head){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.removeAll();
        this.table.setModel(tab1);
        TableColumnModel mc1 = this.table.getColumnModel();
        for (i = 1; i < this.table.getColumnModel().getColumnCount(); ++i) {
            mc1.getColumn(i).setCellRenderer(new numRenderer1());
        }
        mc1.getColumn(0).setPreferredWidth(150);
        mc1.getColumn(1).setPreferredWidth(200);
        mc1.getColumn(2).setPreferredWidth(250);
        for (i = 0; i < this.table.getColumnCount(); ++i) {
            if (i == 0) {
                this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(this.table, 2));
                continue;
            }
            this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(this.table, 2));
        }
    }

    public List<Template> getExposureSelectedList() {
        ArrayList<Template> list = new ArrayList<Template>();
        ArrayList<Node> selected = new ArrayList<Node>(Arrays.asList(this.getExplorerManager().getSelectedNodes()));
        for (Node node : selected) {
            Template b = (Template)((TemplateChildFactory.ExposureBeanNode)node).getmyBean();
            list.add(b);
        }
        return list;
    }

    public List<Template> getExposureFilteredList() {
        ArrayList<Template> list = new ArrayList<Template>();
        ArrayList<Node> filteredNodes = new ArrayList<Node>();
        Outline outline = this.ov.getOutline();
        int numRows = outline.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            Object itemInZerothColumn = outline.getValueAt(i, 0);
            Node aNodeShownInFilter = Visualizer.findNode((Object)itemInZerothColumn);
            filteredNodes.add(aNodeShownInFilter);
        }
        for (Node node : filteredNodes) {
            Template b = (Template)((TemplateChildFactory.ExposureBeanNode)node).getmyBean();
            list.add(b);
        }
        return list;
    }

    void fireAction(JButton cb, String str) {
        str = str.length() == 0 ? cb.getActionCommand() : str;
        ActionListener[] cbActions = cb.getActionListeners();
        for (int i = 0; i < cbActions.length; ++i) {
            cb.getActionListeners()[i].actionPerformed(new ActionEvent(cb, 0, str));
        }
    }

    Integer getInteger(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    static String getString(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        String in = "";
        try {
            in = (String)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : in;
    }

    Float getFloat(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Float in = Float.valueOf(0.0f);
        try {
            in = (Float)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Float.valueOf(in == null ? 0.0f : in.floatValue());
    }

    static void setInteger(Object obj, String name, Integer in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, Integer.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void setFloat(Object obj, String name, Float in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, Float.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setString(Object obj, String name, String in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, String.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    String getDate(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Date in = null;
        DateFormat df = DateFormat.getDateInstance(2, this.getLocale());
        try {
            in = (Date)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : df.format(in);
    }

    Integer oi(Object obj) {
        return obj == null ? 0 : (Integer)obj;
    }

    String os(Object obj) {
        return obj == null ? "" : (String)obj;
    }

    Integer b2i(Boolean b) {
        return b != false ? 1 : 0;
    }

    Boolean i2b(Integer i) {
        return i == null ? false : i == 1;
    }

    private void initComponents() {
        this.jp = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jPanel1 = new JPanel();
        this.bUpdate = new JButton();
        this.bReset = new JButton();
        this.bPrint = new JButton();
        this.bClose = new JButton();
        this.jLabel9 = new JLabel();
        this.bScroll = new JButton();
        this.setDefaultCloseOperation(2);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jScrollPane1.setViewportView(this.table);
        this.jLabel15.setFont(new Font("Tahoma", 1, 14));
        this.jLabel15.setText(NbBundle.getMessage(Report2.class, (String)"Report2.jLabel15.text"));
        this.jLabel15.setToolTipText(NbBundle.getMessage(Report2.class, (String)"Report2.jLabel15.toolTipText"));
        this.jLabel16.setFont(new Font("Tahoma", 0, 10));
        this.jLabel16.setText(NbBundle.getMessage(Report2.class, (String)"Report2.jLabel16.text"));
        this.jLabel16.setToolTipText(NbBundle.getMessage(Report2.class, (String)"Report2.jLabel16.toolTipText"));
        this.bUpdate.setText(NbBundle.getMessage(Report2.class, (String)"Report2.bUpdate.text"));
        this.bUpdate.setActionCommand(NbBundle.getMessage(Report2.class, (String)"Report2.bUpdate.actionCommand"));
        this.bUpdate.setName("bReset");
        this.bReset.setText(NbBundle.getMessage(Report2.class, (String)"Report2.bReset.text"));
        this.bReset.setActionCommand(NbBundle.getMessage(Report2.class, (String)"Report2.bReset.actionCommand"));
        this.bReset.setName("bReset");
        this.bPrint.setText(NbBundle.getMessage(Report2.class, (String)"Report2.bPrint.text"));
        this.bPrint.setToolTipText(NbBundle.getMessage(Report2.class, (String)"Report2.bPrint.toolTipText"));
        this.bPrint.setActionCommand(NbBundle.getMessage(Report2.class, (String)"Report2.bPrint.actionCommand"));
        this.bPrint.setName("bPrint");
        this.bClose.setText(NbBundle.getMessage(Report2.class, (String)"Report2.bClose.text"));
        this.bClose.setActionCommand(NbBundle.getMessage(Report2.class, (String)"Report2.bClose.actionCommand"));
        this.bClose.setName("bReset");
        this.jLabel9.setFont(new Font("Tahoma", 0, 18));
        this.jLabel9.setText(NbBundle.getMessage(Report2.class, (String)"Report2.jLabel9.text"));
        this.bScroll.setText(NbBundle.getMessage(Report2.class, (String)"Report2.bScroll.text"));
        this.bScroll.setToolTipText(NbBundle.getMessage(Report2.class, (String)"Report2.bScroll.toolTipText"));
        this.bScroll.setActionCommand(NbBundle.getMessage(Report2.class, (String)"Report2.bScroll.actionCommand"));
        this.bScroll.setName("bPrint");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9, -1, 586, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bScroll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUpdate, -2, 189, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPrint, -2, 109, -2).addGap(6, 6, 6).addComponent(this.bClose, -2, 109, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bClose).addComponent(this.bUpdate).addComponent(this.bReset).addComponent(this.bPrint).addComponent(this.jLabel9).addComponent(this.bScroll)).addGap(0, 15, Short.MAX_VALUE)));
        GroupLayout jpLayout = new GroupLayout(this.jp);
        this.jp.setLayout(jpLayout);
        jpLayout.setHorizontalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addContainerGap().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jpLayout.createSequentialGroup().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jpLayout.setVerticalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jp, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jp, -2, -1, -2).addGap(0, 170, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Report2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Report2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Report2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Report2.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Report2("FleetDB", 1, "", null).setVisible(true);
            }
        });
    }

    void creatForm() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report2.this.setVisible(true);
            }
        });
    }

    void printIt() {
        this.keepPrinting = true;
        final Report2 comp = this;
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat preformat = pjob.defaultPage();
        preformat.setOrientation(0);
        PageFormat postformat = pjob.pageDialog(preformat);
        if (preformat != postformat) {
            pjob.setPrintable(new Printable(){

                @Override
                public int print(Graphics g, PageFormat pf, int pageprint) throws PrinterException {
                    JDialog dialog;
                    JOptionPane pane;
                    Object[] options;
                    if (!Report2.this.keepPrinting.booleanValue()) {
                        return 1;
                    }
                    if (pageprint > 0) {
                        if (Report2.this.bScroll.isEnabled() || pageprint == Report2.this.page) {
                            if (pageprint != Report2.this.page) {
                                Report2.this.bScroll.doClick();
                                System.out.print("printIt page: " + (Report2.this.page + 1) + "\n");
                                options = new Object[]{"Cancel"};
                                pane = new JOptionPane("Printing page: " + (Report2.this.page + 1), 1, -1, null, options, options[0]);
                                dialog = pane.createDialog("Printing");
                                Report2.this.timer3 = new Timer(1000, new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        EventQueue.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                System.out.print("dialog timer\n");
                                                dialog.setVisible(false);
                                            }
                                        });
                                    }
                                });
                                pane.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent e) {
                                        if (e.getPropertyName().equals("value")) {
                                            System.out.print("User Cancelled Printing\n");
                                            Report2.this.keepPrinting = false;
                                        }
                                    }
                                });
                                Report2.this.timer3.setRepeats(false);
                                Report2.this.timer3.start();
                                dialog.setVisible(true);
                            }
                        } else {
                            return 1;
                        }
                    }
                    if (pageprint == 0 && Report2.this.timer3 == null) {
                        options = new Object[]{"Cancel"};
                        pane = new JOptionPane("Printing page: " + (Report2.this.page + 1), 1, -1, null, options, options[0]);
                        dialog = pane.createDialog("Printing");
                        Report2.this.timer3 = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        System.out.print("dialog timer\n");
                                        dialog.setVisible(false);
                                    }
                                });
                            }
                        });
                        pane.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent e) {
                                if (e.getPropertyName().equals("value")) {
                                    System.out.print("User Cancelled Printing\n");
                                    Report2.this.keepPrinting = false;
                                }
                            }
                        });
                        Report2.this.timer3.setRepeats(false);
                        Report2.this.timer3.start();
                        dialog.setVisible(true);
                    }
                    Dimension dim = comp.getSize();
                    double cHeight = dim.getHeight();
                    double cWidth = dim.getWidth();
                    double pHeight = pf.getImageableHeight();
                    double pWidth = pf.getImageableWidth();
                    double pXStart = pf.getImageableX();
                    double pYStart = pf.getImageableY();
                    double xRatio = pWidth / cWidth;
                    double yRatio = pHeight / cHeight;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.translate(pXStart, pYStart);
                    double scale = Math.min(xRatio, yRatio);
                    g2.scale(scale, scale);
                    comp.paint(g2);
                    return 0;
                }
            });
            if (pjob.printDialog()) {
                try {
                    this.timer3 = null;
                    pjob.print();
                }
                catch (PrinterException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    static {
        em = new ExplorerManager();
        RootName = "Root";
    }

    class ExposureListener
    implements ActionListener {
        ExposureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Reset")) {
                Report2.this.ov.getOutline().unsetQuickFilter();
                Report2.refreshNode(Report2.this.resultList);
                Report2.this.PopulateTable(Report2.this.resultList);
            } else if (cmd.equals("Update")) {
                List<Template> rl = Report2.this.getExposureSelectedList();
                if (rl.isEmpty()) {
                    rl = Report2.this.getExposureFilteredList();
                }
                Report2.refreshNode(rl);
                Report2.this.PopulateTable(rl);
            } else if (cmd.equals("Print")) {
                Report2.this.page = 0;
                Report2.this.ov.getOutline().scrollRectToVisible(new Rectangle(0, 0));
                Report2.this.bScroll.setEnabled((double)Report2.this.ov.getOutline().getVisibleRect().height != Report2.this.ov.getOutline().getSize().getHeight());
                Report2.this.jPanel1.setVisible(false);
                Report2.this.printIt();
                Report2.this.jPanel1.setVisible(true);
                Report2.this.ov.getOutline().scrollRectToVisible(new Rectangle(0, 0));
                Report2.this.jf.setSize(new Dimension(Report2.this.frmwt.intValue(), Report2.this.frmht.intValue()));
            } else if (cmd.equals("Close")) {
                Report2.this.dispose();
            } else if (cmd.equals("Scroll")) {
                ++Report2.this.page;
                final Rectangle rect = Report2.this.ov.getOutline().getVisibleRect();
                Double ovhdr = Report2.this.ov.getOutline().getTableHeader().getSize().getHeight();
                Double ovviewht = Report2.this.ov.getOutline().getSize().getHeight();
                Double ovht = ovviewht + ovhdr;
                Double jpht = Report2.this.jp.getSize().getHeight();
                Report2.this.frmht = Report2.this.jf.getSize().getHeight();
                Report2.this.frmwt = Report2.this.jf.getSize().getWidth();
                Double adj1 = ovviewht - (double)(2 * rect.height) - (double)rect.y;
                Double adj = adj1 > 0.0 ? 0.0 : adj1;
                Double frmhtnew = Report2.this.frmht + adj;
                rect.setRect(rect.x, rect.y + rect.height, rect.width, (double)rect.height + adj);
                Report2.this.jf.setSize(new Dimension(Report2.this.frmwt.intValue(), frmhtnew.intValue()));
                if (adj < 0.0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Report2.this.ov.getOutline().scrollRectToVisible(rect);
                        }
                    });
                    Report2.this.bScroll.setEnabled(false);
                } else {
                    Report2.this.ov.getOutline().scrollRectToVisible(rect);
                }
                String str = "frmht=" + Report2.this.frmht + "/jpht=" + jpht + "/rect.ht=" + rect.height + "/rect.y=" + rect.y + "/frmhtnew=" + frmhtnew + "/ovht=" + ovht + "/ovhdr=" + ovhdr + "/ovviewht=" + ovviewht;
                System.out.println("Frame Resized:" + str);
            }
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer renderer;
        int horAlignment;

        public HeaderRenderer(JTable table, int horizontalAlignment) {
            this.horAlignment = horizontalAlignment;
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            JLabel label = (JLabel)c;
            label.setHorizontalAlignment(this.horAlignment);
            Font fnt = label.getFont();
            label.setFont(new Font(fnt.getFontName(), 1, fnt.getSize() + Report2.this.fntDecr1));
            label.setBackground(Color.darkGray);
            label.setForeground(Color.white);
            return label;
        }
    }

    static class numRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatnum;
        Boolean boo;

        public numRenderer(Boolean boo) {
            this.boo = boo;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                if (this.formatnum == null) {
                    if (this.boo.booleanValue()) {
                        this.formatnum = NumberFormat.getNumberInstance();
                        this.formatnum.setMaximumFractionDigits(0);
                        this.formatnum.setMinimumFractionDigits(0);
                    } else {
                        this.formatnum = NumberFormat.getNumberInstance();
                        this.formatnum.setMaximumFractionDigits(3);
                        this.formatnum.setMinimumFractionDigits(3);
                    }
                }
                try {
                    Float val = (Float)((PropertySupport.Reflection)value).getValue();
                    this.setText(value == null ? "" : this.formatnum.format(val));
                    Font fnt = this.getFont();
                    this.setFont(new Font(fnt.getFontName(), 1, fnt.getSize()));
                    this.setHorizontalAlignment(4);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.setText("");
            }
        }
    }

    public class numRenderer1
    extends JLabel
    implements TableCellRenderer {
        Font fnt = this.getFont();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setFont(new Font(this.fnt.getFontName(), 0, this.fnt.getSize() + Report2.this.fntDecr1));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    public class numRenderer2
    extends DefaultTableCellRenderer {
        NumberFormat formatnum1;
        NumberFormat formatnum2;
        NumberFormat formatnum3;
        Integer in;
        Font fnt = this.getFont();

        public numRenderer2(Integer in) {
            this.in = in;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                if (this.formatnum1 == null) {
                    this.formatnum1 = NumberFormat.getNumberInstance();
                    this.formatnum1.setMaximumFractionDigits(0);
                    this.formatnum1.setMinimumFractionDigits(0);
                    this.formatnum2 = NumberFormat.getNumberInstance();
                    this.formatnum2.setMaximumFractionDigits(3);
                    this.formatnum2.setMinimumFractionDigits(3);
                    this.formatnum3 = NumberFormat.getNumberInstance();
                    this.formatnum3.setMaximumFractionDigits(1);
                    this.formatnum3.setMinimumFractionDigits(1);
                }
                try {
                    this.setHorizontalAlignment(2);
                    if (this.in == 1) {
                        Object obj = ((PropertySupport.Reflection)value).getValue();
                        if (obj instanceof Float) {
                            Float val = (Float)((PropertySupport.Reflection)value).getValue();
                            this.setText(val == null ? "" : this.formatnum1.format(val));
                        } else {
                            String val = (String)obj;
                            this.setText(val == null ? "" : val);
                        }
                    } else if (this.in == 2) {
                        Float val = (Float)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : this.formatnum2.format(val));
                    } else if (this.in == 3) {
                        Integer val = (Integer)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : val.toString());
                        this.setHorizontalAlignment(2);
                    } else if (this.in == 4) {
                        String val = (String)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : val);
                    } else if (this.in == 5) {
                        Float val = (Float)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : this.formatnum3.format(val));
                    } else {
                        Integer val = (Integer)((PropertySupport.Reflection)value).getValue();
                        this.setText(dataField[val][this.in]);
                    }
                    this.setFont(new Font(this.fnt.getFontName(), 1, this.fnt.getSize() + Report2.this.fntDecr1));
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public class numRenderer3
    extends DefaultTableCellRenderer {
        Integer in;

        public numRenderer3(Integer in) {
            this.in = in;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                try {
                    Integer val = (Integer)((PropertySupport.Reflection)value).getValue();
                    this.setText(dataField[val][this.in]);
                    this.setHorizontalAlignment(2);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public class numRenderer4
    extends JLabel
    implements TableCellRenderer {
        Font fnt = this.getFont();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText("" + (row + 1));
            this.setFont(new Font(this.fnt.getFontName(), 0, this.fnt.getSize() + Report2.this.fntDecr1));
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

