/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.silentupdate;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.silentupdate.OutputLogger;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class UpdateHandler {
    public static final String SILENT_UC_CODE_NAME = "org_netbeans_modules_autoupdate_silentupdate_update_center";
    public static Boolean booAbort = false;

    public static boolean timeToCheck() {
        return true;
    }

    public static void checkAndHandleUpdates() {
        OperationContainer<InstallSupport> containerForUpdate;
        String s = NbBundle.getBundle((String)"org.netbeans.modules.autoupdate.silentupdate.resources.Bundle").getString(SILENT_UC_CODE_NAME);
        System.out.println("Update path: " + s);
        UpdateHandler.refreshSilentUpdateProvider();
        if (booAbort.booleanValue()) {
            return;
        }
        Collection<UpdateElement> updates = UpdateHandler.findUpdates();
        Collection<Object> available = Collections.emptySet();
        if (UpdateHandler.installNewModules()) {
            available = UpdateHandler.findNewModules();
        }
        if (updates.isEmpty() && available.isEmpty()) {
            OutputLogger.log("None for install", new Throwable[0]);
            System.out.println("checkAndHandleUpdates: None for install.");
            return;
        }
        OperationContainer<InstallSupport> containerForInstall = UpdateHandler.feedContainer(available, false);
        if (containerForInstall != null) {
            try {
                UpdateHandler.handleInstall(containerForInstall);
                OutputLogger.log("Install new modules done.", new Throwable[0]);
            }
            catch (UpdateHandlerException ex) {
                OutputLogger.log(ex.getLocalizedMessage(), ex.getCause());
                System.out.println("checkAndHandleUpdates: Install new modules done. " + ex.getLocalizedMessage());
                return;
            }
        }
        if ((containerForUpdate = UpdateHandler.feedContainer(updates, true)) != null) {
            try {
                UpdateHandler.handleInstall(containerForUpdate);
                OutputLogger.log("Update done.", new Throwable[0]);
            }
            catch (UpdateHandlerException ex) {
                OutputLogger.log(ex.getLocalizedMessage(), ex.getCause());
                System.out.println("checkAndHandleUpdates: Update done. " + ex.getLocalizedMessage());
                return;
            }
        }
    }

    public static boolean isLicenseApproved(String license) {
        return true;
    }

    static Collection<UpdateElement> findUpdates() {
        HashSet<UpdateElement> elements4update = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits();
        for (UpdateUnit unit : updateUnits) {
            if (unit.getInstalled() == null || unit.getAvailableUpdates().isEmpty()) continue;
            elements4update.add((UpdateElement)unit.getAvailableUpdates().get(0));
            System.out.println("findUpdates: ");
            System.out.println("Installed name: " + unit.getInstalled().getCodeName());
            System.out.println("  Installed version: " + unit.getInstalled().getSpecificationVersion());
            System.out.println("          Update version: " + ((UpdateElement)unit.getAvailableUpdates().get(0)).getSpecificationVersion());
        }
        return elements4update;
    }

    static void handleInstall(OperationContainer<InstallSupport> container) throws UpdateHandlerException {
        if (!UpdateHandler.allLicensesApproved(container)) {
            System.out.println("handleInstall: Cannot continue because license approval is missing for some updates.");
            throw new UpdateHandlerException("Cannot continue because license approval is missing for some updates.");
        }
        InstallSupport support = (InstallSupport)container.getSupport();
        InstallSupport.Validator v = null;
        try {
            v = UpdateHandler.doDownload(support);
        }
        catch (OperationException ex) {
            System.out.println("handleInstall: A problem caught while downloading, cause: ");
            throw new UpdateHandlerException("A problem caught while downloading, cause: ", ex);
        }
        if (v == null) {
            System.out.println("handleInstall: Missing Update Validator => cannot continue.");
            throw new UpdateHandlerException("Missing Update Validator => cannot continue.");
        }
        InstallSupport.Installer i = null;
        try {
            i = UpdateHandler.doVerify(support, v);
        }
        catch (OperationException ex) {
            System.out.println("handleInstall: A problem caught while verification of updates, cause: ");
            throw new UpdateHandlerException("A problem caught while verification of updates, cause: ", ex);
        }
        if (i == null) {
            System.out.println("handleInstall: Missing Update Installer => cannot continue.");
            throw new UpdateHandlerException("Missing Update Installer => cannot continue.");
        }
        OperationSupport.Restarter r = null;
        try {
            r = UpdateHandler.doInstall(support, i);
        }
        catch (OperationException ex) {
            System.out.println("handleInstall: A problem caught while installation of updates, cause: ");
            throw new UpdateHandlerException("A problem caught while installation of updates, cause: ", ex);
        }
        System.out.println("doRestartLater: ");
        support.doRestartLater(r);
        String message = "Software has been updated. Please restart.";
        JOptionPane.showMessageDialog(null, message, "Software Updated", 1);
    }

    public static void doRestartNow(InstallSupport support, OperationSupport.Restarter restarter) {
        ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)"dummy-install-handle");
        try {
            support.doRestart(restarter, installHandle);
        }
        catch (OperationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static Collection<UpdateElement> findNewModules() {
        HashSet<UpdateElement> elements4install = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits();
        for (UpdateUnit unit : updateUnits) {
            if (unit.getInstalled() != null || unit.getAvailableUpdates().isEmpty()) continue;
            elements4install.add((UpdateElement)unit.getAvailableUpdates().get(0));
        }
        return elements4install;
    }

    static void refreshSilentUpdateProvider() {
        UpdateUnitProvider silentUpdateProvider = UpdateHandler.getSilentUpdateProvider();
        if (silentUpdateProvider == null) {
            OutputLogger.log("Missing Silent Update Provider => cannot continue.", new Throwable[0]);
            System.out.println("refreshSilentUpdateProvider: Missing Silent Update Provider => cannot continue.");
            return;
        }
        try {
            silentUpdateProvider.refresh(ProgressHandleFactory.createHandle((String)"dummy-refresh-handle"), true);
        }
        catch (IOException ex) {
            OutputLogger.log("A problem caught while refreshing Update Centers, cause: ", ex);
            System.out.println("refreshSilentUpdateProvider: A problem caught while refreshing Update Centers, cause: ");
        }
    }

    static UpdateUnitProvider getSilentUpdateProvider() {
        List providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
        for (UpdateUnitProvider p : providers) {
            if (!SILENT_UC_CODE_NAME.equals(p.getName())) continue;
            try {
                System.out.println(p);
                p.refresh(ProgressHandleFactory.createHandle((String)"dummy-refresh-handle"), true);
            }
            catch (IOException ex) {
                OutputLogger.log("A problem caught while refreshing Update Centers, cause: ", ex);
                System.out.println("Unable to reach host: " + p.getProviderURL().getHost());
                booAbort = true;
            }
            return p;
        }
        return null;
    }

    static OperationContainer<InstallSupport> feedContainer(Collection<UpdateElement> updates, boolean update) {
        if (updates == null || updates.isEmpty()) {
            return null;
        }
        OperationContainer container = update ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        for (UpdateElement ue : updates) {
            if (!container.canBeAdded(ue.getUpdateUnit(), ue)) continue;
            OutputLogger.log("Update found: " + ue, new Throwable[0]);
            OperationContainer.OperationInfo operationInfo = container.add(ue);
            if (operationInfo == null) continue;
            container.add((Collection)operationInfo.getRequiredElements());
            if (operationInfo.getBrokenDependencies().isEmpty()) continue;
            OutputLogger.log("There are broken dependencies => cannot continue, broken deps: " + operationInfo.getBrokenDependencies(), new Throwable[0]);
            System.out.println("feedContainer: There are broken dependencies => cannot continue, broken deps: ");
            return null;
        }
        return container;
    }

    static boolean allLicensesApproved(OperationContainer<InstallSupport> container) {
        if (!container.listInvalid().isEmpty()) {
            return false;
        }
        for (OperationContainer.OperationInfo info : container.listAll()) {
            String license = info.getUpdateElement().getLicence();
            if (UpdateHandler.isLicenseApproved(license)) continue;
            return false;
        }
        return true;
    }

    static InstallSupport.Validator doDownload(InstallSupport support) throws OperationException {
        ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)"dummy-download-handle");
        return support.doDownload(downloadHandle, true);
    }

    static InstallSupport.Installer doVerify(InstallSupport support, InstallSupport.Validator validator) throws OperationException {
        ProgressHandle validateHandle = ProgressHandleFactory.createHandle((String)"dummy-validate-handle");
        InstallSupport.Installer installer = support.doValidate(validator, validateHandle);
        return installer;
    }

    static OperationSupport.Restarter doInstall(InstallSupport support, InstallSupport.Installer installer) throws OperationException {
        ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)"dummy-install-handle");
        return support.doInstall(installer, installHandle);
    }

    private static boolean installNewModules() {
        String s = NbBundle.getBundle((String)"org.netbeans.modules.autoupdate.silentupdate.resources.Bundle").getString("UpdateHandler.NewModules");
        return Boolean.parseBoolean(s);
    }

    public static class UpdateHandlerException
    extends Exception {
        public UpdateHandlerException(String msg) {
            super(msg);
        }

        public UpdateHandlerException(String msg, Throwable th) {
            super(msg, th);
        }
    }
}

