/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.position;

import org.osgi.util.measurement.Measurement;
import org.osgi.util.measurement.Unit;

public class Position {
    private final Measurement altitude;
    private final Measurement longitude;
    private final Measurement latitude;
    private final Measurement speed;
    private final Measurement track;
    private static final double LON_RANGE = Math.PI;
    private static final double LAT_RANGE = Math.PI / 2.0;
    private static final double TRACK_RANGE = Math.PI * 2.0;

    public Position(Measurement lat, Measurement lon, Measurement alt, Measurement speed, Measurement track) {
        double dtrack;
        if (lat != null && !Unit.rad.equals(lat.getUnit())) {
            throw new IllegalArgumentException("Invalid Latitude");
        }
        if (lon != null && !Unit.rad.equals(lon.getUnit())) {
            throw new IllegalArgumentException("Invalid Longitude");
        }
        if (alt != null && !Unit.m.equals(alt.getUnit())) {
            throw new IllegalArgumentException("Invalid Altitude");
        }
        if (speed != null && !Unit.m_s.equals(speed.getUnit())) {
            throw new IllegalArgumentException("Invalid Speed");
        }
        if (track != null && !Unit.rad.equals(track.getUnit())) {
            throw new IllegalArgumentException("Invalid Track");
        }
        if (lat != null && lon != null) {
            double dlat = lat.getValue();
            double dlon = lon.getValue();
            if (!(dlon >= -LON_RANGE && dlon < LON_RANGE && dlat >= -LAT_RANGE && dlat <= LAT_RANGE)) {
                dlon = Position.normalize(dlon, LON_RANGE);
                if ((dlat = Position.normalize(dlat, LAT_RANGE * 2.0)) > LAT_RANGE || dlat < -LAT_RANGE) {
                    dlon = Position.normalize(dlon - LON_RANGE, LON_RANGE);
                    dlat = Position.normalize(LAT_RANGE * 2.0 - dlat, LAT_RANGE);
                }
                lon = new Measurement(dlon, lon.getError(), lon.getUnit(), lon.getTime());
                lat = new Measurement(dlat, lat.getError(), lat.getUnit(), lat.getTime());
            }
        }
        if (!(track == null || 0.0 <= (dtrack = track.getValue()) && dtrack < TRACK_RANGE)) {
            if ((dtrack %= TRACK_RANGE) < 0.0) {
                dtrack += TRACK_RANGE;
            }
            track = new Measurement(dtrack, track.getError(), track.getUnit(), track.getTime());
        }
        this.latitude = lat;
        this.longitude = lon;
        this.altitude = alt;
        this.speed = speed;
        this.track = track;
    }

    public Measurement getAltitude() {
        return this.altitude;
    }

    public Measurement getLongitude() {
        return this.longitude;
    }

    public Measurement getLatitude() {
        return this.latitude;
    }

    public Measurement getSpeed() {
        return this.speed;
    }

    public Measurement getTrack() {
        return this.track;
    }

    private static double normalize(double value, double range) {
        double twiceRange = 2.0 * range;
        while (value >= range) {
            value -= twiceRange;
        }
        while (value < -range) {
            value += twiceRange;
        }
        return value;
    }
}

