/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote.corba.sun;

import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteCommand;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.remote.corba.sun.CORBARemoteSessionController;

public class CORBAConnection
extends RemoteConnection {
    CORBARemoteSessionController remoteSessionController;

    public CORBAConnection(CORBARemoteSessionController controller) {
        this.remoteSessionController = controller;
    }

    public void processCommand(RemoteCommand command) {
        Transporter transporter = new Transporter();
        transporter.setObject(command);
        transporter = this.getRemoteSessionController().processCommand(transporter);
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void beginTransaction() {
        Transporter transporter = this.getRemoteSessionController().beginTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public RemoteUnitOfWork commitRootUnitOfWork(RemoteUnitOfWork theRemoteUnitOfWork) {
        Transporter transporter = this.getRemoteSessionController().commitRootUnitOfWork(new Transporter(theRemoteUnitOfWork));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (RemoteUnitOfWork)transporter.getObject();
    }

    public void commitTransaction() {
        Transporter transporter = this.getRemoteSessionController().commitTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Session createRemoteSession() {
        return new RemoteSession(this);
    }

    public void cursoredStreamClose(ObjID remoteCursoredStreamOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamClose(new Transporter(remoteCursoredStreamOid));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Vector cursoredStreamNextPage(RemoteCursoredStream remoteCursoredStream, ReadQuery query, RemoteSession session, int pageSize) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamNextPage(new Transporter(remoteCursoredStream.getID()), pageSize);
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Vector<Object> serverNextPageObjects = (Vector<Object>)transporter.getObject();
        if (serverNextPageObjects == null) {
            this.cursoredStreamClose(remoteCursoredStream.getID());
            return null;
        }
        Vector<Object> clientNextPageObjects = serverNextPageObjects;
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            clientNextPageObjects = new Vector<Object>(serverNextPageObjects.size());
            Enumeration objEnum = serverNextPageObjects.elements();
            while (objEnum.hasMoreElements()) {
                Object clientObject = session.getObjectCorrespondingTo(objEnum.nextElement(), transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
                clientNextPageObjects.addElement(clientObject);
            }
        }
        return clientNextPageObjects;
    }

    public int cursoredStreamSize(ObjID remoteCursoredStreamID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamSize(new Transporter(remoteCursoredStreamID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy policy, DistributedSession session) {
        Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(policy));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
        remoteCursoredStream.setSession(session);
        remoteCursoredStream.setPolicy(policy);
        if (policy.getQuery().isReadAllQuery() && !policy.getQuery().isReportQuery()) {
            this.fixObjectReferences(transporter, (ObjectLevelReadQuery)policy.getQuery(), (RemoteSession)session);
        }
        return remoteCursoredStream;
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy policy, DistributedSession session) {
        Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(policy));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        RemoteScrollableCursor remoteScrollableCursor = (RemoteScrollableCursor)transporter.getObject();
        remoteScrollableCursor.setSession(session);
        remoteScrollableCursor.setPolicy(policy);
        return remoteScrollableCursor;
    }

    public void fixObjectReferences(Transporter remoteCursoredStream, ObjectLevelReadQuery query, RemoteSession session) {
        RemoteCursoredStream stream = (RemoteCursoredStream)remoteCursoredStream.getObject();
        List<Object> remoteObjectCollection = stream.getObjectCollection();
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            Vector<Object> clientObjectCollection = new Vector<Object>(remoteObjectCollection.size());
            IdentityHashMap recursiveSet = new IdentityHashMap(remoteObjectCollection.size() + 1);
            for (Object serverSideDomainObject : remoteObjectCollection) {
                clientObjectCollection.addElement(session.getObjectCorrespondingTo(serverSideDomainObject, remoteCursoredStream.getObjectDescriptors(), recursiveSet, query));
            }
            stream.setObjectCollection(clientObjectCollection);
        }
    }

    public ClassDescriptor getDescriptor(Class domainClass) {
        Transporter transporter = this.getRemoteSessionController().getDescriptor(new Transporter(domainClass));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (ClassDescriptor)transporter.getObject();
    }

    public Vector getDefaultReadOnlyClasses() {
        Transporter transporter = this.getRemoteSessionController().getDefaultReadOnlyClasses();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Vector)transporter.getObject();
    }

    public Login getLogin() {
        Transporter transporter = this.getRemoteSessionController().getLogin();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Login)transporter.getObject();
    }

    public CORBARemoteSessionController getRemoteSessionController() {
        return this.remoteSessionController;
    }

    public Object getSequenceNumberNamed(Object remoteFunctionCall) {
        Transporter transporter = this.getRemoteSessionController().getSequenceNumberNamed(new Transporter(remoteFunctionCall));
        Object returnValue = transporter.getObject();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return returnValue;
    }

    public void initializeIdentityMapsOnServerSession() {
        Transporter transporter = this.getRemoteSessionController().initializeIdentityMapsOnServerSession();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Transporter instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        Transporter transporter = this.getRemoteSessionController().instantiateRemoteValueHolderOnServer(new Transporter(remoteValueHolder));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public Transporter remoteExecute(DatabaseQuery query) {
        Transporter transporter = this.getRemoteSessionController().executeQuery(new Transporter(query));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public Transporter remoteExecuteNamedQuery(String name, Class javaClass, Vector arguments) {
        Transporter transporter = this.getRemoteSessionController().executeNamedQuery(new Transporter(name), new Transporter(javaClass), new Transporter(arguments));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public void rollbackTransaction() {
        Transporter transporter = this.getRemoteSessionController().rollbackTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public boolean scrollableCursorAbsolute(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAbsolute(new Transporter(remoteScrollableCursorOid), rows);
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public void scrollableCursorAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(remoteScrollableCursorOid));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorBeforeFirst(new Transporter(remoteScrollableCursorOid));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorClose(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorClose(new Transporter(remoteScrollableCursorOid));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public int scrollableCursorCurrentIndex(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return -1;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public boolean scrollableCursorFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorFirst(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsAfterLast(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsBeforeFirst(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsFirst(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsLast(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorLast(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public Object scrollableCursorNextObject(ObjID remoteScrollableCursorOid, ReadQuery query, RemoteSession session) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorNextObject(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    public Object scrollableCursorPreviousObject(ObjID remoteScrollableCursorOid, ReadQuery query, RemoteSession session) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorPreviousObject(new Transporter(remoteScrollableCursorOid));
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    public boolean scrollableCursorRelative(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorRelative(new Transporter(remoteScrollableCursorOid), rows);
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public int scrollableCursorSize(ObjID cursorId) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorSize(new Transporter(cursorId));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public void setRemoteSessionController(CORBARemoteSessionController remoteSessionController) {
        this.remoteSessionController = remoteSessionController;
    }
}

