/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class WIExplorerCertStore
implements CertStore {
    protected static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    protected static final String OID_EKU_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    protected static final String OID_EKU_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private Collection certs = new ArrayList();

    WIExplorerCertStore() {
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("iexplorer.cert.loading", new Object[]{this.getName()});
        this.certs.clear();
        this.loadCertificates(this.getName(), this.getExtendedKeyUsageFilters(), this.certs);
        Trace.msgSecurityPrintln("iexplorer.cert.loaded", new Object[]{this.getName()});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new KeyStoreException("Cannot store certificate in Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        throw new KeyStoreException("Cannot add certificate in Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        throw new KeyStoreException("Cannot remove certificate from Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("iexplorer.cert.instore", new Object[]{this.getName()});
        return this.certs.contains(certificate);
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("iexplorer.cert.canverify", new Object[]{this.getName()});
        Trace.msgSecurityPrintln("iexplorer.cert.tobeverified", new Object[]{certificate});
        Iterator iterator = this.getCertificates().iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            Trace.msgSecurityPrintln("iexplorer.cert.tobecompared", new Object[]{this.getName(), x509Certificate});
            try {
                certificate.verify(x509Certificate.getPublicKey());
                Trace.msgSecurityPrintln("iexplorer.cert.verify.ok", new Object[]{this.getName()});
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("iexplorer.cert.verify.fail", new Object[]{this.getName()});
        return false;
    }

    public Collection getCertificates() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Iterator iterator = this.certs.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            arrayList.add(certificate);
        }
        return arrayList;
    }

    private native void loadCertificates(String var1, String[] var2, Collection var3);

    private void generateCertificate(byte[] byArray, Collection collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection2 = certificateFactory.generateCertificates(byteArrayInputStream);
            Iterator<? extends Certificate> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                collection.add(x509Certificate);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected abstract String getName();

    protected abstract String[] getExtendedKeyUsageFilters();

    static {
        Platform.get().loadDeployNativeLib();
    }
}

