/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resolver {
    private boolean nullAllowed;
    private final Resolver parent;
    private Map<String, Resolver> resolvers;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    Resolver(Resolver parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    public abstract void accept(ResolverVisitor var1);

    final void addChild(String variableName, Resolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new HashMap<String, Resolver>();
        }
        this.resolvers.put(variableName, resolver);
    }

    IType buildType() {
        return this.getTypeDeclaration().getType();
    }

    abstract ITypeDeclaration buildTypeDeclaration();

    void checkParent(Resolver parent) {
        if (parent == null) {
            throw new NullPointerException("The parent resolver cannot be null");
        }
    }

    final Resolver getChild(String variableName) {
        return this.resolvers != null ? this.resolvers.get(variableName) : null;
    }

    public IManagedType getManagedType() {
        return null;
    }

    public IMapping getMapping() {
        return null;
    }

    public Resolver getParent() {
        return this.parent;
    }

    final IManagedType getParentManagedType() {
        return this.parent.getManagedType();
    }

    final IMapping getParentMapping() {
        return this.parent.getMapping();
    }

    final IType getParentType() {
        return this.parent.getType();
    }

    final ITypeDeclaration getParentTypeDeclaration() {
        return this.parent.getTypeDeclaration();
    }

    final IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    IQuery getQuery() {
        return this.parent.getQuery();
    }

    public final IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    final IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    final IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    final ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    final TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    final ITypeRepository getTypeRepository() {
        return this.getQuery().getProvider().getTypeRepository();
    }

    public final boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }
}

