/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.tk.FontMetrics;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class TextFieldSkin
extends TextInputControlSkin<TextField, TextFieldBehavior> {
    public Group textGroup = new Group();
    private Rectangle clip = new Rectangle();
    private Text textNode = new Text();
    private Text promptNode;
    private Path selectionHighlightPath = new Path();
    private Path characterBoundingPath = new Path();
    private ObservableBooleanValue usePromptText;
    private DoubleProperty textTranslateX = new SimpleDoubleProperty(this, "textTranslateX");
    private DoubleProperty textTranslateY = new SimpleDoubleProperty(this, "textTranslateY");
    private ObservableIntegerValue caretPosition;
    private double caretWidth;
    private BooleanProperty forwardBias = new BooleanPropertyBase(){

        @Override
        public Object getBean() {
            return TextFieldSkin.this;
        }

        @Override
        public String getName() {
            return "forwardBias";
        }

        @Override
        protected void invalidated() {
            if (TextFieldSkin.this.getWidth() > 0.0) {
                TextFieldSkin.this.textNode.impl_caretBiasProperty().set(this.get());
                TextFieldSkin.this.updateCaretOff();
            }
        }
    };
    protected ObservableDoubleValue textLeft;
    protected ObservableDoubleValue textRight;
    private double pressX;
    private double pressY;

    protected int translateCaretPosition(int n) {
        return n;
    }

    protected Point2D translateCaretPosition(Point2D point2D) {
        return point2D;
    }

    public TextFieldSkin(TextField textField) {
        this(textField, new TextFieldBehavior(textField));
    }

    public TextFieldSkin(final TextField textField, TextFieldBehavior textFieldBehavior) {
        super(textField, textFieldBehavior);
        textFieldBehavior.setTextFieldSkin(this);
        this.caretPosition = new IntegerBinding(){
            {
                this.bind(textField.caretPositionProperty());
            }

            @Override
            protected int computeValue() {
                return textField.getCaretPosition();
            }
        };
        this.caretPosition.addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (TextFieldSkin.this.getWidth() > 0.0) {
                    TextFieldSkin.this.textNode.impl_caretPositionProperty().set(TextFieldSkin.this.translateCaretPosition(TextFieldSkin.this.caretPosition.get()));
                    if (!TextFieldSkin.this.forwardBias.get()) {
                        TextFieldSkin.this.forwardBias.set(true);
                    }
                    TextFieldSkin.this.updateCaretOff();
                }
            }
        });
        this.textLeft = new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getInsets().getLeft();
            }
        };
        ChangeListener<Number> changeListener = new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (TextFieldSkin.this.getWidth() > 0.0) {
                    TextFieldSkin.this.updateTextPos();
                    TextFieldSkin.this.updateCaretOff();
                }
            }
        };
        this.textLeft.addListener(changeListener);
        this.textRight = new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.widthProperty(), TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getWidth() - TextFieldSkin.this.getInsets().getRight();
            }
        };
        this.textRight.addListener(changeListener);
        this.setManaged(false);
        this.clip.setSmooth(false);
        this.clip.xProperty().bind(new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getInsets().getLeft();
            }
        });
        this.clip.yProperty().bind(new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getInsets().getTop();
            }
        });
        this.clip.widthProperty().bind(new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.widthProperty(), TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getWidth() - TextFieldSkin.this.getInsets().getRight() - TextFieldSkin.this.getInsets().getLeft();
            }
        });
        this.clip.heightProperty().bind(new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.heightProperty(), TextFieldSkin.this.insets());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.getHeight() - TextFieldSkin.this.getInsets().getTop() - TextFieldSkin.this.getInsets().getBottom();
            }
        });
        this.textGroup.setManaged(false);
        this.textGroup.setClip(this.clip);
        this.textGroup.getChildren().addAll((Node[])new Node[]{this.selectionHighlightPath, this.textNode, this.caretPath});
        this.getChildren().add(this.textGroup);
        if (PlatformUtil.isEmbedded()) {
            this.getChildren().addAll((Node[])new Node[]{this.caretHandle, this.selectionHandle1, this.selectionHandle2});
        }
        this.textNode.setManaged(false);
        this.textNode.getStyleClass().add("text");
        this.textNode.fontProperty().bind(this.font);
        this.textNode.xProperty().bind(this.textLeft);
        this.textNode.layoutXProperty().bind(this.textTranslateX);
        this.textNode.textProperty().bind(new StringBinding(){
            {
                this.bind(textField.textProperty());
            }

            @Override
            protected String computeValue() {
                String string = TextFieldSkin.this.maskText(textField.getText());
                return string == null ? "" : string;
            }
        });
        this.textNode.fillProperty().bind(this.textFill);
        this.textNode.impl_selectionFillProperty().bind((ObservableValue<Paint>)new ObjectBinding<Paint>(){
            {
                this.bind(TextFieldSkin.this.highlightTextFill, TextFieldSkin.this.textFill, textField.focusedProperty());
            }

            @Override
            protected Paint computeValue() {
                return textField.isFocused() ? (Paint)TextFieldSkin.this.highlightTextFill.get() : (Paint)TextFieldSkin.this.textFill.get();
            }
        });
        this.textNode.impl_caretPositionProperty().set(textField.getCaretPosition());
        textField.selectionProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TextFieldSkin.this.updateSelection();
            }
        });
        this.selectionHighlightPath.setManaged(false);
        this.selectionHighlightPath.setStroke(null);
        this.selectionHighlightPath.layoutXProperty().bind(this.textTranslateX);
        this.selectionHighlightPath.layoutYProperty().bind(this.textTranslateY);
        this.selectionHighlightPath.visibleProperty().bind(textField.anchorProperty().isNotEqualTo(this.caretPosition).and(textField.focusedProperty()));
        this.selectionHighlightPath.fillProperty().bind(this.highlightFill);
        this.textNode.impl_selectionShapeProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TextFieldSkin.this.updateSelection();
            }
        });
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFill);
        this.caretPath.strokeProperty().bind(this.textFill);
        this.caretPath.visibleProperty().bind(this.caretVisible);
        this.caretPath.layoutXProperty().bind(this.textTranslateX);
        this.caretPath.layoutYProperty().bind(this.textTranslateY);
        this.textNode.impl_caretShapeProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TextFieldSkin.this.caretPath.getElements().setAll((PathElement[])((Object[])TextFieldSkin.this.textNode.impl_caretShapeProperty().get()));
                TextFieldSkin.this.caretWidth = Math.round(TextFieldSkin.this.caretPath.getLayoutBounds().getWidth());
            }
        });
        this.font.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TextFieldSkin.this.requestLayout();
                ((TextField)TextFieldSkin.this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener(textField.prefColumnCountProperty(), "prefColumnCount");
        if (textField.isFocused()) {
            this.setCaretAnimating(true);
        }
        textField.alignmentProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (TextFieldSkin.this.getWidth() > 0.0) {
                    TextFieldSkin.this.updateTextPos();
                    TextFieldSkin.this.updateCaretOff();
                    TextFieldSkin.this.requestLayout();
                }
            }
        });
        this.usePromptText = new BooleanBinding(){
            {
                this.bind(textField.textProperty(), textField.promptTextProperty());
            }

            @Override
            protected boolean computeValue() {
                String string = textField.getText();
                String string2 = textField.getPromptText();
                return (string == null || string.isEmpty()) && string2 != null && !string2.isEmpty();
            }
        };
        textField.textProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (!((TextFieldBehavior)TextFieldSkin.this.getBehavior()).isEditing()) {
                    TextFieldSkin.this.updateTextPos();
                }
            }
        });
        if (this.usePromptText.get()) {
            this.createPromptNode();
        }
        this.usePromptText.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TextFieldSkin.this.createPromptNode();
                TextFieldSkin.this.requestLayout();
            }
        });
        if (PlatformUtil.isEmbedded()) {
            this.selectionHandle1.setRotate(180.0);
            EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    TextFieldSkin.this.pressX = mouseEvent.getX();
                    TextFieldSkin.this.pressY = mouseEvent.getY();
                    mouseEvent.consume();
                }
            };
            this.caretHandle.setOnMousePressed((EventHandler<? super MouseEvent>)eventHandler);
            this.selectionHandle1.setOnMousePressed((EventHandler<? super MouseEvent>)eventHandler);
            this.selectionHandle2.setOnMousePressed((EventHandler<? super MouseEvent>)eventHandler);
            this.caretHandle.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    Point2D point2D = new Point2D(TextFieldSkin.this.caretHandle.getLayoutX() + mouseEvent.getX() + TextFieldSkin.this.pressX - TextFieldSkin.this.textNode.getLayoutX(), TextFieldSkin.this.caretHandle.getLayoutY() + mouseEvent.getY() - TextFieldSkin.this.pressY - 6.0);
                    HitInfo hitInfo = TextFieldSkin.this.textNode.impl_hitTestChar(TextFieldSkin.this.translateCaretPosition(point2D));
                    int n = hitInfo.getCharIndex();
                    TextFieldSkin.this.positionCaret(hitInfo, false);
                    mouseEvent.consume();
                }
            });
            this.selectionHandle1.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    TextField textField = (TextField)TextFieldSkin.this.getSkinnable();
                    Point2D point2D = TextFieldSkin.this.textNode.localToScene(0.0, 0.0);
                    Point2D point2D2 = new Point2D(mouseEvent.getSceneX() - point2D.getX() + 10.0 - TextFieldSkin.this.pressX + TextFieldSkin.this.selectionHandle1.getWidth() / 2.0, mouseEvent.getSceneY() - point2D.getY() - TextFieldSkin.this.pressY - 6.0);
                    HitInfo hitInfo = TextFieldSkin.this.textNode.impl_hitTestChar(TextFieldSkin.this.translateCaretPosition(point2D2));
                    int n = hitInfo.getCharIndex();
                    if (textField.getAnchor() < textField.getCaretPosition()) {
                        textField.selectRange(textField.getCaretPosition(), textField.getAnchor());
                    }
                    if (n >= 0) {
                        if (n >= textField.getAnchor() - 1) {
                            hitInfo.setCharIndex(Math.max(0, textField.getAnchor() - 1));
                        }
                        TextFieldSkin.this.positionCaret(hitInfo, true);
                    }
                    mouseEvent.consume();
                }
            });
            this.selectionHandle2.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    TextField textField = (TextField)TextFieldSkin.this.getSkinnable();
                    Point2D point2D = TextFieldSkin.this.textNode.localToScene(0.0, 0.0);
                    Point2D point2D2 = new Point2D(mouseEvent.getSceneX() - point2D.getX() + 10.0 - TextFieldSkin.this.pressX + TextFieldSkin.this.selectionHandle2.getWidth() / 2.0, mouseEvent.getSceneY() - point2D.getY() - TextFieldSkin.this.pressY - 6.0);
                    HitInfo hitInfo = TextFieldSkin.this.textNode.impl_hitTestChar(TextFieldSkin.this.translateCaretPosition(point2D2));
                    int n = hitInfo.getCharIndex();
                    if (textField.getAnchor() > textField.getCaretPosition()) {
                        textField.selectRange(textField.getCaretPosition(), textField.getAnchor());
                    }
                    if (n > 0) {
                        if (n <= textField.getAnchor()) {
                            hitInfo.setCharIndex(Math.min(textField.getAnchor() + 1, textField.getLength()));
                        }
                        TextFieldSkin.this.positionCaret(hitInfo, true);
                    }
                    mouseEvent.consume();
                }
            });
        }
    }

    private void createPromptNode() {
        if (this.promptNode != null || !this.usePromptText.get()) {
            return;
        }
        this.promptNode = new Text();
        this.textGroup.getChildren().add(0, this.promptNode);
        this.promptNode.setManaged(false);
        this.promptNode.getStyleClass().add("text");
        this.promptNode.visibleProperty().bind(this.usePromptText);
        this.promptNode.fontProperty().bind(this.font);
        this.promptNode.xProperty().bind(this.textLeft);
        this.promptNode.layoutXProperty().set(0.0);
        this.promptNode.textProperty().bind(((TextField)this.getSkinnable()).promptTextProperty());
        this.promptNode.fillProperty().bind(this.promptTextFill);
        this.updateSelection();
    }

    private void updateSelection() {
        IndexRange indexRange = ((TextField)this.getSkinnable()).getSelection();
        if (indexRange == null || indexRange.getLength() == 0) {
            this.textNode.impl_selectionStartProperty().set(-1);
            this.textNode.impl_selectionEndProperty().set(-1);
        } else {
            this.textNode.impl_selectionStartProperty().set(indexRange.getStart());
            this.textNode.impl_selectionEndProperty().set(indexRange.getStart());
            this.textNode.impl_selectionEndProperty().set(indexRange.getEnd());
        }
        PathElement[] pathElementArray = (PathElement[])this.textNode.impl_selectionShapeProperty().get();
        if (pathElementArray == null) {
            this.selectionHighlightPath.getElements().clear();
        } else {
            this.selectionHighlightPath.getElements().setAll((PathElement[])pathElementArray);
        }
        if (PlatformUtil.isEmbedded() && indexRange != null && indexRange.getLength() > 0) {
            Bounds bounds = this.selectionHighlightPath.getBoundsInParent();
            this.selectionHandle1.setLayoutX(bounds.getMinX() - this.selectionHandle1.getWidth() / 2.0);
            this.selectionHandle2.setLayoutX(bounds.getMaxX() - this.selectionHandle2.getWidth() / 2.0);
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        if ("prefColumnCount".equals(string)) {
            this.requestLayout();
            ((TextField)this.getSkinnable()).requestLayout();
        } else {
            super.handleControlPropertyChanged(string);
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        TextField textField = (TextField)this.getSkinnable();
        double d2 = ((FontMetrics)this.fontMetrics.get()).computeStringWidth("W");
        int n = textField.getPrefColumnCount();
        Insets insets = this.getInsets();
        return (double)n * d2 + (insets.getLeft() + insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = ((FontMetrics)this.fontMetrics.get()).getLineHeight();
        Insets insets = this.getInsets();
        return d2 + (insets.getTop() + insets.getBottom());
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((TextField)this.getSkinnable()).prefHeight(d);
    }

    @Override
    public double getBaselineOffset() {
        FontMetrics fontMetrics = this.fontMetrics.get();
        return this.getInsets().getTop() + (double)fontMetrics.getAscent();
    }

    private void updateTextPos() {
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                double d = (this.textRight.get() - this.textLeft.get()) / 2.0;
                this.textTranslateX.set(d - this.textNode.getLayoutBounds().getWidth() / 2.0);
                break;
            }
            case RIGHT: {
                this.textTranslateX.set(this.textRight.get() - this.textNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0 - 5.0);
                break;
            }
            default: {
                this.textTranslateX.set(this.caretWidth / 2.0);
            }
        }
    }

    protected void updateCaretOff() {
        double d = 0.0;
        double d2 = this.caretPath.getLayoutBounds().getMinX() + this.textTranslateX.get();
        if (d2 < this.textLeft.get()) {
            d = d2 - this.textLeft.get();
        } else if (d2 > this.textRight.get() - this.caretWidth) {
            d = d2 - (this.textRight.get() - this.caretWidth);
        }
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                this.textTranslateX.set(this.textTranslateX.get() - d);
                break;
            }
            case RIGHT: {
                this.textTranslateX.set(Math.max(this.textTranslateX.get() - d, this.textRight.get() - this.textNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0 - 5.0));
                break;
            }
            default: {
                this.textTranslateX.set(Math.min(this.textTranslateX.get() - d, this.caretWidth / 2.0));
            }
        }
        if (PlatformUtil.isEmbedded()) {
            this.caretHandle.setLayoutX(d2 - this.caretHandle.getWidth() / 2.0 + 1.0);
        }
    }

    public void replaceText(int n, int n2, String string) {
        double d = this.textNode.getBoundsInParent().getMaxX();
        double d2 = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        ((TextField)this.getSkinnable()).replaceText(n, n2, string);
        this.scrollAfterDelete(d, d2);
    }

    public void deleteChar(boolean bl) {
        boolean bl2;
        double d = this.textNode.getBoundsInParent().getMaxX();
        double d2 = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        boolean bl3 = bl ? !((TextField)this.getSkinnable()).deletePreviousChar() : (bl2 = !((TextField)this.getSkinnable()).deleteNextChar());
        if (!bl2) {
            this.scrollAfterDelete(d, d2);
        }
    }

    public void scrollAfterDelete(double d, double d2) {
        Bounds bounds = this.textNode.getLayoutBounds();
        Bounds bounds2 = this.textNode.localToParent(bounds);
        Bounds bounds3 = this.clip.getBoundsInParent();
        Bounds bounds4 = this.caretPath.getLayoutBounds();
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                this.updateTextPos();
                break;
            }
            case RIGHT: {
                if (bounds2.getMaxX() > bounds3.getMaxX()) {
                    double d3 = d2 - bounds4.getMaxX() - this.textTranslateX.get();
                    if (bounds2.getMaxX() + d3 < bounds3.getMaxX()) {
                        d3 = d <= bounds3.getMaxX() ? d - bounds2.getMaxX() : bounds3.getMaxX() - bounds2.getMaxX();
                    }
                    this.textTranslateX.set(this.textTranslateX.get() + d3);
                    break;
                }
                this.updateTextPos();
                break;
            }
            default: {
                if (!(bounds2.getMinX() < bounds3.getMinX() + this.caretWidth / 2.0) || !(bounds2.getMaxX() <= bounds3.getMaxX())) break;
                double d4 = d2 - bounds4.getMaxX() - this.textTranslateX.get();
                if (bounds2.getMaxX() + d4 < bounds3.getMaxX()) {
                    d4 = d <= bounds3.getMaxX() ? d - bounds2.getMaxX() : bounds3.getMaxX() - bounds2.getMaxX();
                }
                this.textTranslateX.set(this.textTranslateX.get() + d4);
            }
        }
        this.updateCaretOff();
    }

    public HitInfo getIndex(MouseEvent mouseEvent) {
        Point2D point2D = new Point2D(mouseEvent.getX() - this.textNode.getLayoutX(), mouseEvent.getY() - this.textTranslateY.get());
        return this.textNode.impl_hitTestChar(this.translateCaretPosition(point2D));
    }

    public void setForwardBias(boolean bl) {
        this.forwardBias.set(bl);
    }

    public void positionCaret(HitInfo hitInfo, boolean bl) {
        boolean bl2;
        int n = hitInfo.getInsertionIndex();
        boolean bl3 = bl2 = n > 0 && n < ((TextField)this.getSkinnable()).getLength() && this.maskText(((TextField)this.getSkinnable()).getText()).codePointAt(n - 1) == 10;
        if (!hitInfo.isLeading() && bl2) {
            hitInfo.setLeading(true);
            --n;
        }
        if (bl) {
            ((TextField)this.getSkinnable()).selectPositionCaret(n);
        } else {
            ((TextField)this.getSkinnable()).positionCaret(n);
        }
        this.setForwardBias(hitInfo.isLeading());
    }

    @Override
    public Rectangle2D getCharacterBounds(int n) {
        double d;
        double d2;
        double d3;
        double d4;
        Bounds bounds;
        if (n == this.textNode.getText().length()) {
            bounds = this.textNode.getBoundsInLocal();
            d4 = bounds.getMaxX();
            d3 = 0.0;
            d2 = 0.0;
            d = bounds.getMaxY();
        } else {
            this.characterBoundingPath.getElements().clear();
            this.characterBoundingPath.getElements().addAll((PathElement[])this.textNode.impl_getRangeShape(n, n + 1));
            this.characterBoundingPath.setLayoutX(this.textNode.getLayoutX());
            this.characterBoundingPath.setLayoutY(this.textNode.getLayoutY());
            bounds = this.characterBoundingPath.getBoundsInLocal();
            d4 = bounds.getMinX();
            d3 = bounds.getMinY();
            d2 = bounds.isEmpty() ? 0.0 : bounds.getWidth();
            d = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        }
        bounds = this.textGroup.getBoundsInParent();
        return new Rectangle2D(d4 + bounds.getMinX(), d3 + bounds.getMinY(), d2, d);
    }

    @Override
    protected PathElement[] getUnderlineShape(int n, int n2) {
        return this.textNode.impl_getUnderlineShape(n, n2);
    }

    @Override
    protected PathElement[] getRangeShape(int n, int n2) {
        return this.textNode.impl_getRangeShape(n, n2);
    }

    @Override
    protected void addHighlight(List<? extends Node> list, int n) {
        this.textGroup.getChildren().addAll((Collection<Node>)list);
    }

    @Override
    protected void removeHighlight(List<? extends Node> list) {
        this.textGroup.getChildren().removeAll((Collection<?>)list);
    }

    @Override
    protected void layoutChildren() {
        Object object;
        super.layoutChildren();
        if (this.textNode != null) {
            double d;
            object = this.getInsets();
            FontMetrics fontMetrics = (FontMetrics)this.fontMetrics.get();
            switch (((TextField)this.getSkinnable()).getAlignment().getVpos()) {
                case TOP: {
                    d = ((Insets)object).getTop() + (double)fontMetrics.getMaxAscent();
                    break;
                }
                case CENTER: {
                    d = (((Insets)object).getTop() + (double)fontMetrics.getMaxAscent() + this.getHeight() - ((Insets)object).getBottom() - (double)fontMetrics.getMaxDescent()) / 2.0;
                    break;
                }
                default: {
                    d = this.getHeight() - ((Insets)object).getBottom() - (double)fontMetrics.getMaxDescent();
                }
            }
            this.textNode.setY(d);
            if (this.promptNode != null) {
                this.promptNode.setY(d);
            }
        }
        if (PlatformUtil.isEmbedded()) {
            TextField textField = (TextField)this.getSkinnable();
            IndexRange indexRange = textField.getSelection();
            this.selectionHandle1.resize(this.selectionHandle1.prefWidth(-1.0), this.selectionHandle1.prefHeight(-1.0));
            this.selectionHandle2.resize(this.selectionHandle2.prefWidth(-1.0), this.selectionHandle2.prefHeight(-1.0));
            this.caretHandle.resize(this.caretHandle.prefWidth(-1.0), this.caretHandle.prefHeight(-1.0));
            object = this.caretPath.getBoundsInParent();
            this.caretHandle.setLayoutY(((Bounds)object).getMaxY() - 1.0);
            this.selectionHandle1.setLayoutY(((Bounds)object).getMinY() - this.selectionHandle1.getHeight() + 1.0);
            this.selectionHandle2.setLayoutY(((Bounds)object).getMaxY() - 1.0);
        }
    }

    @Override
    public Point2D getMenuPosition() {
        Point2D point2D = super.getMenuPosition();
        if (point2D != null) {
            Insets insets = this.getInsets();
            point2D = new Point2D(Math.max(0.0, point2D.getX() - this.textNode.getLayoutX() - insets.getLeft() + this.textTranslateX.get()), Math.max(0.0, point2D.getY() - this.textNode.getLayoutY() - insets.getTop()));
        }
        return point2D;
    }
}

