/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ColorPicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class ColorPickerBehavior
extends ComboBoxBaseBehavior<Color> {
    protected static final String OPEN_ACTION = "Open";
    protected static final String CLOSE_ACTION = "Close";
    protected static final List<KeyBinding> COLOR_PICKER_BINDINGS = new ArrayList<KeyBinding>();

    public ColorPickerBehavior(ColorPicker colorPicker) {
        super(colorPicker);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return COLOR_PICKER_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        ColorPicker colorPicker = (ColorPicker)this.getControl();
        if (OPEN_ACTION.equals(string)) {
            this.show();
        } else if (CLOSE_ACTION.equals(string)) {
            this.hide();
        } else {
            super.callAction(string);
        }
    }

    private ColorPicker getColorPicker() {
        return (ColorPicker)this.getControl();
    }

    @Override
    public void onAutoHide() {
        this.wasComboBoxButtonClickedForAutoHide = this.mouseInsideButton;
        ColorPicker colorPicker = (ColorPicker)this.getControl();
        ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
        colorPickerSkin.syncWithAutoUpdate();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            super.mouseReleased(mouseEvent);
        } else {
            this.disarm();
        }
    }

    static {
        COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_PRESSED, CLOSE_ACTION));
        COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, OPEN_ACTION));
        COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, OPEN_ACTION));
    }
}

