/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.awt.Robot;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class RobotRetriever {
    private static final Logger log = Logger.getLogger(RobotRetriever.class.getName());
    private static Robot robot;

    public static synchronized Robot getRobot() throws InterruptedException, ExecutionException, TimeoutException {
        if (robot != null) {
            return robot;
        }
        FutureTask<Robot> robotRetriever = new FutureTask<Robot>(new Retriever());
        log.info("Creating Robot");
        Thread retrieverThread = new Thread(robotRetriever, "robotRetriever");
        retrieverThread.start();
        robot = robotRetriever.get(10L, TimeUnit.SECONDS);
        return robot;
    }

    private static class Retriever
    implements Callable<Robot> {
        private Retriever() {
        }

        @Override
        public Robot call() throws Exception {
            return new Robot();
        }
    }
}

