/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.HeartbeatMessage;
import sun.plugin2.message.Message;
import sun.plugin2.message.Pipe;
import sun.plugin2.util.SystemUtil;

public class HeartbeatThread
extends Thread {
    private static final boolean DEBUG = SystemUtil.isDebug();
    private static final boolean VERBOSE = SystemUtil.isVerbose();
    private static final long TIMEOUT_AFTER_SLEEP = 30000L;
    private static final int SLEEP_THRESHOLD_MULTIPLIER = 2;
    private final Pipe pipe;
    private final boolean clientSide;
    protected boolean alive = true;
    protected Conversation conversation;
    protected HeartbeatMessage beat;
    private long MICRO_COUNT = 1000000L;

    public HeartbeatThread(String string, Pipe pipe) {
        this(string, pipe, true);
        this.setDaemon(true);
    }

    public HeartbeatThread(String string, Pipe pipe, boolean bl) {
        super(string + "-Heartbeat");
        this.pipe = pipe;
        this.clientSide = bl;
    }

    protected boolean keepBeating() {
        return this.alive;
    }

    public void stopBeating() {
        this.alive = false;
        this.interrupt();
    }

    protected void handleStart() throws InterruptedException, IOException {
        if (!this.alive) {
            throw new IllegalStateException("Cannot start already stopped heart");
        }
        if (this.clientSide) {
            Message message;
            if (this.conversation == null && (message = this.pipe.receive(10000L)) instanceof HeartbeatMessage) {
                this.beat = (HeartbeatMessage)message;
                this.conversation = this.beat.getConversation();
            }
            if (this.conversation == null || !this.pipe.joinConversation(this.conversation)) {
                throw new InternalError("Client failed to join heartbeat conversation " + this.conversation);
            }
            if (DEBUG) {
                System.out.println(this.getName() + " joined conversation: " + this.conversation);
            }
        } else {
            this.conversation = this.pipe.beginConversation();
            this.beat = Pipe.isLoggingEnabled() ? new HeartbeatMessage(this.conversation, 5000L, 30000L) : new HeartbeatMessage(this.conversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = SystemUtils.microTime();
        try {
            try {
                this.handleStart();
                while (this.keepBeating()) {
                    long l2;
                    l = SystemUtils.microTime();
                    if (this.clientSide) {
                        this.beat.updateHealthData();
                    }
                    this.pipe.send(this.beat);
                    this.recordPingDiagnostics(l);
                    Message message = this.pipe.receive(this.beat.getTimeout(), this.conversation);
                    if (message == null && (l2 = (SystemUtils.microTime() - l) / 1000L) > this.beat.getTimeout() * 2L) {
                        long l3 = 30000L;
                        if (DEBUG) {
                            System.out.println(this.getName() + ": pipe read returns null elapsed=" + l2 + " millis while timeout=" + this.beat.getTimeout() + " Possible system sleep scenario, retry read.");
                        }
                        message = this.pipe.receive(l3, this.conversation);
                    }
                    if (message == null) {
                        this.alive = false;
                        this.recordNoAckDiagnostics(l);
                        this.handleNoAck();
                        break;
                    }
                    this.recordAckDiagnostics(l);
                    this.handleAck();
                    this.beat = (HeartbeatMessage)message;
                    HeartbeatThread heartbeatThread = this;
                    synchronized (heartbeatThread) {
                        this.wait(this.beat.getInterval());
                    }
                }
                Object var10_8 = null;
                if (this.conversation != null) {
                    this.pipe.endConversation(this.conversation);
                }
                this.handleStop();
            }
            catch (Exception exception) {
                this.handleException(exception, l);
                Object var10_9 = null;
                if (this.conversation != null) {
                    this.pipe.endConversation(this.conversation);
                }
                this.handleStop();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.conversation != null) {
                this.pipe.endConversation(this.conversation);
            }
            this.handleStop();
            throw throwable;
        }
    }

    private long elapsedSecondsSince(long l) {
        return (SystemUtils.microTime() - l) / this.MICRO_COUNT;
    }

    protected void handleException(Exception exception, long l) {
        long l2 = this.elapsedSecondsSince(l);
        String string = this.getName() + " heartbeat dead, exception. dT=" + l2 + " seconds.";
        if (DEBUG) {
            System.out.println(string);
            exception.printStackTrace();
        }
    }

    protected void handleStop() {
    }

    protected void recordPingDiagnostics(long l) {
        if (VERBOSE) {
            System.out.println(this.getName() + " sent heartbeat: " + this.beat);
        }
    }

    protected void recordAckDiagnostics(long l) {
        if (VERBOSE) {
            long l2 = SystemUtils.microTime() - l;
            System.out.println(this.getName() + " round-trip heartbeat took " + l2 + " microsecs.");
        }
    }

    protected void recordNoAckDiagnostics(long l) {
        long l2 = this.elapsedSecondsSince(l);
        if (DEBUG) {
            System.out.println(this.getName() + " heartbeat dead, waited " + l2 + " seconds.");
        }
    }

    protected void handleNoAck() {
    }

    protected void handleAck() {
    }
}

