/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPQLExpression
extends AbstractExpression {
    private AbstractExpression queryStatement;
    private boolean tolerant;
    private AbstractExpression unknownEndingStatement;
    private IJPAVersion version;

    public JPQLExpression(CharSequence query, IJPAVersion version) {
        this(query, version, false);
    }

    public JPQLExpression(CharSequence query, IJPAVersion version, boolean tolerant) {
        this(version, tolerant);
        this.parse(new WordParser(query), tolerant);
    }

    private JPQLExpression(IJPAVersion version, boolean tolerant) {
        super(null);
        this.checkVersion(version);
        this.tolerant = tolerant;
        this.version = version;
    }

    public static Expression parseConditionalExpression(String abstractSchemaName, CharSequence conditionalExpression, IJPAVersion version, boolean tolerant) {
        JPQLExpression expression = new JPQLExpression(version, tolerant);
        expression.checkQuery(conditionalExpression);
        SelectStatement selectStatement = expression.addSelectStatement();
        FromClause fromClause = selectStatement.addFromClause();
        fromClause.setIdentificationVariableDeclaration(abstractSchemaName, "this");
        WhereClause whereClause = selectStatement.addWhereClause();
        whereClause.parse(conditionalExpression, tolerant);
        return whereClause.getConditionalExpression();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getQueryStatement().accept(visitor);
        this.getUnknownEndingStatement().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getQueryStatement());
        children.add(this.getUnknownEndingStatement());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.queryStatement != null) {
            children.add(this.queryStatement);
        }
        if (this.unknownEndingStatement != null) {
            children.add(this.unknownEndingStatement);
        }
    }

    private SelectStatement addSelectStatement() {
        SelectStatement selectStatement = new SelectStatement(this);
        this.queryStatement = selectStatement;
        return selectStatement;
    }

    public QueryPosition buildPosition(String actualQuery, int position) {
        position = ExpressionTools.repositionCursor(actualQuery, position, this.toActualText());
        QueryPosition queryPosition = new QueryPosition(position);
        this.populatePosition(queryPosition, position);
        return queryPosition;
    }

    private AbstractExpression buildQueryStatement(WordParser wordParser) {
        switch (wordParser.character()) {
            case 'D': 
            case 'd': {
                return new DeleteStatement(this);
            }
            case 'U': 
            case 'u': {
                return new UpdateStatement(this);
            }
        }
        return new SelectStatement(this);
    }

    private void checkQuery(CharSequence query) {
        if (query == null) {
            throw new NullPointerException("The query cannot be null");
        }
    }

    private void checkVersion(IJPAVersion version) {
        if (version == null) {
            throw new NullPointerException("The IJPAVersion cannot be null");
        }
    }

    public Expression getExpression(String actualQuery, int position) {
        QueryPosition queryPosition = this.buildPosition(actualQuery, position);
        return queryPosition.getExpression();
    }

    @Override
    public IJPAVersion getJPAVersion() {
        return this.version;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return JPQLExpression.queryBNF("ql_statement");
    }

    public Expression getQueryStatement() {
        if (this.queryStatement == null) {
            this.queryStatement = this.buildNullExpression();
        }
        return this.queryStatement;
    }

    public AbstractExpression getUnknownEndingStatement() {
        if (this.unknownEndingStatement == null) {
            this.unknownEndingStatement = this.buildNullExpression();
        }
        return this.unknownEndingStatement;
    }

    public IJPAVersion getVersion() {
        return this.version;
    }

    public boolean hasQueryStatement() {
        return this.queryStatement != null && !this.queryStatement.isNull();
    }

    public boolean hasUnknownEndingStatement() {
        return this.unknownEndingStatement != null && !this.unknownEndingStatement.isNull();
    }

    @Override
    boolean isTolerant() {
        return this.tolerant;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.skipLeadingWhitespace();
        if (tolerant) {
            this.queryStatement = this.parseSingleExpression(wordParser, this.getQueryBNF(), tolerant);
            int count = wordParser.skipLeadingWhitespace();
            if (this.queryStatement == null || !wordParser.isTail()) {
                wordParser.moveBackward(count);
                this.unknownEndingStatement = this.buildUnknownExpression(wordParser.substring());
            } else if (!wordParser.isTail() || tolerant && count > 0) {
                this.unknownEndingStatement = this.buildUnknownExpression(" ");
            }
        } else {
            this.queryStatement = this.buildQueryStatement(wordParser);
            this.queryStatement.parse(wordParser, tolerant);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.queryStatement != null) {
            this.queryStatement.toParsedText(writer, includeVirtual);
        }
        if (this.unknownEndingStatement != null) {
            this.unknownEndingStatement.toParsedText(writer, includeVirtual);
        }
    }
}

