/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SelectNode
extends QueryNode {
    private List selectExpressions = new ArrayList();
    private List identifiers = new ArrayList();
    private boolean distinct = false;

    public List getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(List exprs) {
        this.selectExpressions = exprs;
    }

    public List getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List identifiers) {
        this.identifiers = identifiers;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public DatabaseQuery createDatabaseQuery(ParseTreeContext context) {
        ReadAllQuery query = this.isReadAllQuery(context) ? new ReadAllQuery() : new ReportQuery();
        query.dontUseDistinct();
        return query;
    }

    private boolean isReadAllQuery(ParseTreeContext context) {
        if (!this.isSingleSelectExpression()) {
            return false;
        }
        Node node = this.getFirstSelectExpressionNode();
        if (!node.isVariableNode()) {
            return false;
        }
        String variable = ((VariableNode)node).getCanonicalVariableName();
        String baseVariable = this.getParseTree().getFromNode().getFirstVariable();
        if (!context.isRangeVariable(baseVariable)) {
            return false;
        }
        return baseVariable.equals(variable);
    }

    public void applyToQuery(DatabaseQuery theQuery, GenerationContext context) {
        ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)theQuery;
        if (this.selectExpressions.isEmpty()) {
            return;
        }
        if (!(this.isSingleSelectExpression() && this.getFirstSelectExpressionNode().isCountNode() || !this.usesDistinct())) {
            this.getParseTree().setDistinctState((short)1);
            readQuery.setDistinctState((short)1);
        }
        if (readQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)readQuery;
            reportQuery.returnWithoutReportQueryResult();
            if (this.isSingleSelectExpression()) {
                reportQuery.returnSingleAttribute();
            }
        }
        SelectGenerationContext selectContext = (SelectGenerationContext)context;
        for (int i = 0; i < this.selectExpressions.size(); ++i) {
            String alias;
            Node node = (Node)this.selectExpressions.get(i);
            if (this.selectingRelationshipField(node, context)) {
                selectContext.useOuterJoins();
            }
            if (node.isAliasableNode() && this.identifiers != null && (alias = (String)this.identifiers.get(i)) != null) {
                ((AliasableNode)((Object)node)).setAlias(alias);
            }
            node.applyToQuery(readQuery, context);
            selectContext.dontUseOuterJoins();
        }
        readQuery.setShouldBuildNullForNullPk(this.hasOneToOneSelected(context));
    }

    public boolean hasOneToOneSelected(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (!this.hasOneToOneSelected(node, context)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneToOneSelected(Node node, GenerationContext context) {
        if (node.isCountNode()) {
            return false;
        }
        if (node.isAggregateNode()) {
            return this.hasOneToOneSelected(node.getLeft(), context);
        }
        if (node.isVariableNode()) {
            return !this.nodeRefersToObject(node, context);
        }
        if (node.isConstructorNode()) {
            List args = ((ConstructorNode)node).getConstructorItems();
            for (Node arg : args) {
                if (!this.hasOneToOneSelected(arg, context)) continue;
                return true;
            }
            return false;
        }
        return !this.selectingDirectToField(node, context);
    }

    public void verifySelectedAlias(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (node.isDotNode()) {
                return;
            }
            node.resolveClass(context);
        }
    }

    public boolean isSelected(String variableName) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode() || !((VariableNode)node).getCanonicalVariableName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectNode() {
        return true;
    }

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        for (int i = 0; i < this.selectExpressions.size(); ++i) {
            Node item = (Node)this.selectExpressions.get(i);
            this.selectExpressions.set(i, item.qualifyAttributeAccess(context));
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        for (Node item : this.selectExpressions) {
            item.validate(context);
        }
    }

    public Class resolveClass(GenerationContext context) {
        return this.getReferenceClass(context);
    }

    public Expression generateExpression(GenerationContext context) {
        return null;
    }

    public Class getReferenceClass(GenerationContext context) {
        return this.getClassOfFirstVariable(context);
    }

    private Class getClassOfFirstVariable(GenerationContext context) {
        Class clazz = null;
        String variable = this.getParseTree().getFromNode().getFirstVariable();
        ParseTreeContext parseTreeContext = context.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(variable)) {
            String schema = parseTreeContext.schemaForVariable(variable);
            clazz = parseTreeContext.classForSchemaName(schema, context);
        } else {
            Node path = parseTreeContext.pathForVariable(variable);
            clazz = path.resolveClass(context);
        }
        return clazz;
    }

    public boolean isVariableInINClauseSelected(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode()) continue;
            String variableNameForLeft = ((VariableNode)node).getCanonicalVariableName();
            if (context.getParseTreeContext().isRangeVariable(variableNameForLeft)) continue;
            return true;
        }
        return false;
    }

    public boolean nodeRefersToObject(Node node, GenerationContext context) {
        ClassDescriptor descriptor;
        if (!node.isVariableNode()) {
            return false;
        }
        String name = ((VariableNode)node).getCanonicalVariableName();
        String alias = context.getParseTreeContext().schemaForVariable(name);
        return alias != null && (descriptor = context.getSession().getDescriptorForAlias(alias)) != null;
    }

    private boolean selectingRelationshipField(Node node, GenerationContext context) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        TypeHelper typeHelper = context.getParseTreeContext().getTypeHelper();
        Node path = node.getLeft();
        AttributeNode attribute = (AttributeNode)node.getRight();
        return typeHelper.isRelationship(path.getType(), attribute.getAttributeName());
    }

    private boolean selectingDirectToField(Node node, GenerationContext context) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        return ((DotNode)node).endsWithDirectToField(context);
    }

    private Node getFirstSelectExpressionNode() {
        return this.selectExpressions.size() > 0 ? (Node)this.selectExpressions.get(0) : null;
    }

    private boolean isSingleSelectExpression() {
        return this.selectExpressions.size() == 1;
    }
}

